<span id="version" style="color: grey; float: right">Version 1.3.0</span>

# Customer Segmentation for Banking

Retail bank customers are diverse in terms of demographics, behavior, and potential economic value. Historical data can be processed to define groups of customers that have similar characteristics. Understanding how these segments are constituted, how profitable they are to the bank, and how customers end up in the most profitable segments yields insights on how to improve the bank’s business. These segments are inputs of business decision-making, KPI calculations, and a wide array of marketing use-cases including customer lifetime value, churn product recommendation, and next best offer.

The approach taken here uses machine learning in the form of a clustering algorithm to identify distinct clusters of customers, which are referred to in our analysis as Segments. Further analysis is carried out to understand these clusters, and how they related to the bank's product mix and existing customer tiering approaches.

The [Next Best Offer for Banking](https://www.dataiku.com/solutions/catalog/next-best-offer-for-banking/) solution completes the customer segmentation solution within the marketing suite for banking. The user can plug the same data as in the current solution, and build an initial model. Additionally, the user can use the segmentation output as an input in the Next Best Offer for Banking solution. 

# Key Outcomes

 - [Create and configure your own customer segmentation project](article:5): connect your own data to the project's data model, tweak a few elements of the configuration to suit your needs, then run the Flow to immediately generate insights.
 - [Leverage Visual ML capabilities for Unsupervised Learning](article:6): segment your customers in a pure data-centric way using unsupervised learning via K Means clustering.
 
 ![Outcomes 1.png](ZYf3CAhYLBxF)
 
 - [Move directly to actionable insights via the prebuilt dashboards](article:7): including an easy-to-understand breakdown of the newly discovered Segments, and comparison and contrast with existing business metrics and client analytics.

![Outcomes 2.png](LJxPBjLnXWgc)

![Outcomes 3.png](Kyt7piO3c3ko)

![Outcomes 4.png](UhQPjY7QSpFH)

