Scenarios are predefined series of steps that automate operations in the project. Since the project has some plug-and-play features and configuration options defined in the [Dataiku Application](article:11), parameters are enforced in the flow using scenarios. Some of these scenarios are called from the buttons in the Dataiku Application, these are flagged with the dataiku-application tag, while others are not called directly from a button but by other scenarios. Each scenario will be briefly explained below.

![Scenarios.png](mLi2xiVDcBCe)

# Base Scenarios

## [ load_application_variables](scenario:LOAD_APPLICATION_VARIABLES)

This scenario is called each time a button is pushed on the Dataiku Application, it commits local project variables to global project variables which are the ones that will be consumed in the project.

## [ load_tables](scenario:LOAD_TABLES)

Edit the five first prepare recipes that remap column names to the ones required in the project and add the optional columns defined in the Dataiku Application. Then run these recipes.

# Dataiku Application Scenarios

## [ reconfigure_flow_connections_settings](scenario:RECONFIGURE_FLOW_CONNECTIONS_SETTINGS)

Load the application variables then changes all the flow's datasets to the connection defined in the Dataiku Application. Currently, only Snowflake and PostgreSQL connections are supported.

## [ load_data_sources](scenario:LOAD_DATA_SOURCES)

Again, application variables are loaded by calling the first scenario. Then, from the user-defined table names, input data sources are set up. If tables are not found, the scenario will output an error. Finally, recipe engines are switched to prepare recipes that support SQL engines. All other recipes have their engines automatically switched to SQL, but to prepare a recipe, an additional step is necessary, while doing it, we check that the underlying SQL database supports the computations done in the recipe (for instance, it happens that some are supported in Snowflake but not in PostgreSQL).

## [ rebuild_dates](scenario:REBUILD_DATES)

Call the load_tables scenario, then builds the dates preparation zone until [historical_dates](dataset:historical_dates), to have the list of all possible reference dates in the data. These reference dates are the last date of each month present in the data. The user will select in the Dataiku Application from this list the project reference date that will be used for the clustering.
 
 ## [ rebuild_flow](scenario:REBUILD_FLOW)
 
 Rebuild the whole flow. This scenario calls sequentially all the below scenarios to progressively rebuild the flow until the dashboard.
 
 # Rebuild Flow Scenarios
 
 ## [ update_customer_data_schema](scenario:UPDATE_CUSTOMER_DATA_SCHEMA)
 
Update schemas in the thread coming from the customer_data dataset and rebuild datasets. It implies updating the join recipe to contain the appropriate optional columns and the prepared recipe and rebuilding these.
 
 ## [ update_additional_information_schema](scenario:update_additional_information_schema)

Similar to the above scenario, update the schemas for the join recipe to include the optional columns. Rebuild until the grouping recipe where aggregations have to be computed for all the optional columns defined. Finally, rebuild the final dataset.

 ## [ update_balances_and_revenues](scenario:UPDATE_BALANCES_AND_REVENUES)
 
Build all datasets until the pivot recipe, then build the pivot recipe that will create a new schema depending on the list of product types in the data. Then the prepared recipe is edited to rename the columns programmatically from the automatic renaming occurring in the pivot recipe. And it is built.

 ## [ update_customer_full_data](scenario:update_customer_full_data)
 
Update the join recipe to include all the additional variables and columns that have been created previously. Then build the join and the split between reference and historical data.
 
 ## [ update_model](scenario:UPDATE_MODEL)
 
Update the model to take into account all the variables, and also updates the number of clusters as defined in the Dataiku Application. After the training, the clusters are renamed using the facts outputted by Dataiku, and the model is redeployed on the flow, ready to score data.
 
 ## [ propagate_analysis](scenario:PROPAGATE_ANALYSIS)
 
 Propagate the schemas from the customer_reference_data and the customer_historical_data datasets to the end of the flow.
 
 ## [ rebuild_graphs](scenario:REBUILD_GRAPHS)
 
Build the right-hand part of the flow, from the scoring to the dashboard. First, the reference period is set in the windows recipe that computes the transition probabilities between segments. Then all is rebuilt and charts from the dashboard are refreshed.

