This zone handles the preparation of both [customers](dataset:customers) and [additional_information](dataset:additional_information).

![Customer Data Preparation Zone.png](HovZGPZAtnWo)

In the initial Join Recipes ([compute_customer_data_history](recipe:compute_customer_data_history), [compute_additional_information_history](recipe:compute_additional_information_history)), a cartesian product is computed between the [dates_history](dataset:dates_history) dataset and each of these two initial datasets. This replicates the initial datasets as many times as the number of rows in the dates_history dataset, so that each historical computation will be performed for every period.

Then, in a [Prepare Recipe](recipe:compute_customer_data_prepared), customer age and account age are computed as the difference between the reference date and birth date, and between the reference date and creation date, respectively. As cleanup, the two date columns are removed.

In another [Prepare Recipe](recipe:compute_additional_information_prepared), the time between the date in the dataset and the reference date is computed. This enables us to define the in_history variable that flags rows which are included under the lookback period defined in the [Dataiku Application](article:11). Only rows where in_history is true are kept, and temporary variables that were created are removed. Finally, the [Grouping Recipe](recipe:compute_additional_information_last) computes the last and average for each of the features per customer and reference date.
