The balances and revenues Zone handles the preparation of [balances](dataset:balances) and [revenues](dataset:revenues) datasets.

![Screenshot 2023-06-01 at 11.55.39.png](kgJLuMklwNmz)

The initial datasets are [joined](recipe:compute_balances_product) together and also enriched by the [products](dataset:products) dataset, adding information about the product and product type. As with the other preparation steps, the dataset is joined with the dates_history dataset using a [cartesian product](recipe:compute_balances_history). In the subsequent [Prepare Recipe](recipe:compute_balances_product_prepared_1) empty cells for revenues are filled with 0, indicating a situation in which for a particular product a customer had a balance but no revenue was generated. The time difference between the date of the balance and revenue, and the reference date is computed, to then define the in_history variable and keep only rows that belong to the lookback period. Temporary variables are removed, and two grouping variables are applied sequentially:

 - [compute_balances_history_average](recipe:compute_balances_history_average): average, last balance and revenue are computed for each customer and product on each reference period.
 - [compute_balances_product_summary](recipe:compute_balances_product_summary): values are aggregated back to a product type level, by taking the sum of all balances and revenues, and counting the number of products per product type.
 
Using a [Pivot Recipe](recipe:compute_balances_product_summary_customer) data is transposed from a long format to a wide format, to obtain one row per customer and reference date. A set of five columns is created for each product type. For simplicity of process we select 'sum' as the aggregation though for this particular dataset there is only one value in each aggregation.

 - product_count: the total number of products.
 - balance_avg_sum: the total balance on the product type on average during the reference period.
 - balance_last_sum: the total balance on the product type during the last month.
 - revenue_avg_sum: the total revenue on the product type on average during the reference period.
 - revenue_last_sum: the total revenue on the product type during the last month.

Finally, a [Prepare Recipe](recipe:compute_balances_product_summary_customer_prepared) fills in empty cells with zeroes and renames the columns created in the previous pivot recipe with more descriptive names.


