The transition analysis focuses on how customers move between segments.

![Transition Analysis Zone.png](HNaXKwINEByt)

The [historical scored dataset](dataset:customer_historical_data_scored) contains the assigned segment for each customer_id over time. The initial [windows recipe](recipe:compute_customer_historical_data_scored_transitions) computes for each customer, the 1 period lag and the reference lookback period lag. In the output section of the recipe, column names are modified to cluster_labels_lag_month and cluster_labels_lag_reference to indicate that one lag refers to the monthly transition while the other refers to the transition over the lookback period. Then, in the [grouping recipe](recipe:compute_segment_transitions), segment transitions are counted by taking the count over the key: cluster_labels, cluster_labels_lag_month, cluster_labels_lag_reference. The next [windows recipe](recipe:compute_segment_transitions_share) computes the total sum of count for each cluster_labels to normalize the counts in the following [prepare recipe](recipe:compute_transitions_share).

Finally, the upper two grouping recipes aggregate the month transitions and the reference transitions respectively. It produces synthetic datasets that can be explored using a [Sankey chart](https://www.dataiku.com/product/plugins/flow-charts/) which is exported in the dashboard. In the lower part of the flow zone, the stability of the segments is computed separately for monthly transitions and reference transitions. It is achieved by filtering on the lag segment being equal to the segment and summing the transitions for each of the two-period lags. Then the two datasets are [stacked](recipe:compute_transitions_stability) together to produce one unique graph showing both transitions' stability.


