シナリオとは、プロジェクト内の操作を自動化するための、あらかじめ定義された一連のステップのことです。プロジェクトには、[Dataikuアプリケーション](Article:11)で定義されたプラグアンドプレイ機能や設定オプションがあるため、シナリオを使用したフローでは、パラメータが強制的に使用されます。これらのシナリオの中には、Dataikuアプリケーションのボタンから呼び出されるもの（これらはdataiku-applicationタグが付けられています）と、ボタンから直接呼び出されず他のシナリオによって呼び出されるものがあります。各シナリオについて、以下に簡単に説明します。

![Scenarios.png](mLi2xiVDcBCe)

# 基本シナリオ/Base Scenarios

## [ load_application_variables](scenario:LOAD_APPLICATION_VARIABLES)

このシナリオは、Dataikuアプリケーション上でボタンが押されるたびに呼び出され、ローカルプロジェクト変数を、プロジェクト内で消費されるグローバルプロジェクト変数に置き換えます。

## [ load_tables](scenario:LOAD_TABLES)

最初の5つの準備レシピを編集し、カラム名をプロジェクトで必要なものにリマップし、Dataikuアプリケーションで定義されたオプションカラムを追加します。次に、これらのレシピを実行します。

# Dataikuアプリケーションシナリオ/Dataiku Application Scenarios

## [ reconfigure_flow_connections_settings](scenario:RECONFIGURE_FLOW_CONNECTIONS_SETTINGS)

アプリケーション変数を読み込むと、すべてのフローのデータセットがDataikuアプリケーションで定義された接続に変更されます。現在、SnowflakeとPostgreSQLの接続のみサポートされています。

## [ load_data_sources](scenario:LOAD_DATA_SOURCES)

ここでも、最初のシナリオを呼び出すことで、アプリケーション変数がロードされます。そして、ユーザー定義のテーブル名から、入力データソースを設定します。テーブルが見つからない場合、シナリオはエラーを出力します。最後に、SQLエンジンをサポートするレシピを準備するために、レシピエンジンが切り替わります。他のすべてのレシピは、そのエンジンが自動的にSQLに切り替えられていますが、レシピを準備するために、追加のステップが必要です。それをしながら、基礎となるSQLデータベースがレシピで行われる計算をサポートしているかどうかをチェックします（例えば、SnowflakeではサポートされているがPostgreSQLではないものがあるということが起こります）。

## [ rebuild_dates](scenario:REBUILD_DATES)

load_tablesシナリオを呼び出し、[historical_dates](dataset:historical_dates)まで日付準備ゾーンを構築し、データ中の参照可能なすべての日付のリストを得ます。これらの基準日は、データ中に存在する各月の最終日です。ユーザーはDataikuアプリケーションで、このリストからクラスタリングに使用するプロジェクトの基準日を選択します。
 
 ## [ rebuild_flow](scenario:REBUILD_FLOW)
 
フロー全体を再構築します。このシナリオでは、以下の全てのシナリオを順次呼び出し、ダッシュボードまでのフローを順次再構築していきます。
 
 # 再ビルドフローシナリオ/Rebuild Flow Scenarios
 
 ## [ update_customer_data_schema](scenario:UPDATE_CUSTOMER_DATA_SCHEMA)
 
customer_dataデータセットから来るスレッドのスキーマを更新し、データセットを再構築します。これは、適切なオプションのカラムを含む結合レシピと準備されたレシピを更新し、これらを再構築することを意味します。
 
 ## [ update_additional_information_schema](scenario:update_additional_information_schema)

上記のシナリオと同様に、オプショナルのカラムを含むように結合レシピのスキーマを更新します。グループ化のレシピまで再構築し、そこで定義されたすべてのオプションのカラムに対して集約を計算しなければなりません。最後に、最終的なデータセットを再構築します。

 ## [ update_balances_and_revenues](scenario:UPDATE_BALANCES_AND_REVENUES)
 
ピボットレシピまでの全てのデータセットを構築し、データ中の商品タイプのリストによって新しいスキーマを作成するピボットレシピを構築します。そして、用意したレシピを編集して、ピボットレシピで発生している自動リネームからプログラム的にカラム名を変更し再構築されます。

 ## [ update_customer_full_data](scenario:update_customer_full_data)
 
ジョインレシピを更新して、以前に作成した追加変数とカラムをすべて含めます。その後、結合と参照データと履歴データ間の分割を構築します。
 
 ## [ update_model](scenario:UPDATE_MODEL)
 
すべての変数を考慮してモデルを更新し、Dataikuアプリケーションで定義されたクラスタ数を更新します。学習後、Dataikuが出力したファクトを用いてクラスタ名を変更し、モデルをフロー上に再展開し、データをスコアリングできる状態にします。
 
 ## [ propagate_analysis](scenario:PROPAGATE_ANALYSIS)
 
 customer_reference_dataとcustomer_historical_dataのデータセットから、フローの末尾にスキーマを伝搬させます。
 
 ## [ rebuild_graphs](scenario:REBUILD_GRAPHS)
 
スコアリングからダッシュボードまでのフローの右側部分を構築します。まず、セグメント間の遷移確率を計算するウィンドウズレシピに基準期間を設定する。その後、すべてを再構築し、ダッシュボードのチャートをリフレッシュします。

