このプロジェクトはプラグ・アンド・プレイ方式を採用しており、お持ちのデータを簡単に接続し、すぐに結果を得ることができます。同時に、このプロジェクトのすべてのコンポーネントは完全にカスタマイズ可能であり、出力と手法をあなたの正確なニーズに合わせることができます。プラグ・アンド・プレイを使用するには、入力データが以下に説明するデータモデルと一致している必要があります。プロジェクトには既存のサンプルデータが同梱されており、接続しなくてもすぐにその機能と結果を試すことができます。

# データモデル

## [Customer Data（顧客データ）](dataset:customer_data_input)

顧客の基本情報

- customer_id (テキスト（string型）：顧客を一意に特定する識別子)
- tier (テキスト（string型）：銀行内部で管理している顧客カテゴリー)
- income (数値（bigint型）：顧客の年収)
- creation_date (日付（Date型）：顧客となった開始日)
- birth_date (日付（Date型）：顧客の生年月日)
- 顧客の属性に関する追加情報は、「追加情報」（下記参照）として記載することができます。

## [Product Holdings（保有商品）](dataset:product_holdings_input)

顧客ごとの過去の商品保有状況。

- customer_id (テキスト（string型）：顧客を一意に特定する識別子)
- product_type (テキスト（string型）：商品の種類　例：ローン、カード、口座など）
- product (テキスト（string型）：特定金融商品　例：具体的なローンの種類、カードの種類など）
- product_id (数値（bigint型）：製品ごとの固有識別子)
- start_date (日付（Date型）：特定顧客・商品の開始日)
- end_date (日付（Date型）：特定顧客・商品の終了日、空白の場合は継続中となる

## [Balances（残高）](dataset:balances_input)

顧客・商品別の残高履歴

- customer_id (テキスト（string型）：顧客を一意に特定する識別子)
- product_id (数値（bigint型）：製品ごとの固有識別子)
- balance (数値（double型）：顧客・商品別の対象日の残高)
- date (日付（Date型）：残高の対象日)

## [Revenues（売上高）](dataset:revenues_input)

特定顧客から得た売上の合計。この初期分析では、収益をタイプ別（例：有料、無料）に分割していないことに留意してください。

- customer_id (テキスト（string型）：顧客を一意に特定する識別子)
- product_id (数値（bigint型）：製品ごとの固有識別子)
- revenue (数値（double型）： 月別の売上高)
- date (日付（Date型）：対象月の最終日)

## [Additional Information（追加情報）](dataset:additional_information_input)

分析を充実させるためのオプションの追加情報です。

- customer_id (テキスト（string型）：顧客を一意に特定する識別子)
- date (日付（Date型）：対象月の最終日)
- 月次ベースで、顧客の様々なフィールドと関連する値







