def numerical_values_processing(preprocessing='AVGSTD'):
    NUMERICAL_VALUES_PROCESSING = {
        'generate_derivative': False,
        'numerical_handling': 'REGULAR',
        'missing_handling': 'IMPUTE',
        'missing_impute_with': 'MEDIAN',
        'impute_constant_value': 0.0,
        'keep_regular': False,
        'rescaling': preprocessing,
        'quantile_bin_nb_bins': 4,
        'binarize_threshold_mode': 'MEDIAN',
        'binarize_constant_threshold': 0.0,
        'datetime_cyclical_periods': [],
        'role': 'INPUT',
        'type': 'NUMERIC',
        'customHandlingCode': '',
        'customProcessorWantsMatrix': False,
        'sendToInput': 'main'
    }
    return NUMERICAL_VALUES_PROCESSING

CATEGORICAL_VALUES_PROCESSING = {
    'category_handling': 'DUMMIFY',
    'missing_handling': 'NONE',
    'missing_impute_with': 'MODE',
    'dummy_clip': 'MAX_NB_CATEGORIES',
    'cumulative_proportion': 0.95,
    'min_samples': 10,
    'max_nb_categories': 100,
    'max_cat_safety': 200,
    'nb_bins_hashing': 1048576,
    'hash_whole_categories': True,
    'dummy_drop': 'AUTO',
    'impact_method': 'M_ESTIMATOR',
    'impact_m': 10,
    'impact_kfold': True,
    'impact_kfold_k': 5,
    'impact_kfold_seed': 1337,
    'ordinal_order': 'COUNT',
    'ordinal_ascending': False,
    'ordinal_default_mode': 'HIGHEST',
    'ordinal_default_value': 0,
    'frequency_default_mode': 'EXPLICIT',
    'frequency_default_value': 0.0,
    'frequency_normalized': True,
    'role': 'INPUT',
    'type': 'CATEGORY',
    'customHandlingCode': '',
    'customProcessorWantsMatrix': False,
    'sendToInput': 'main'
}

CUSTOMER_DATA_MANDATORY_COLUMNS = {"customer_id": "string",
                           "tier": "string",
                           "income": "bigint",
                           "creation_date": "date",
                           "birth_date": "date"}

PRODUCT_HOLDINGS_COLUMNS = {"customer_id": "string",
                            "product_type": "string",
                            "product": "string",
                            "product_id": "string",
                            "start_date": "date",
                            "end_date": "date"}

BALANCES_COLUMNS = {"customer_id": "string",
                    "product_id": "string",
                    "balance": "double",
                    "date": "date"}

REVENUES_COLUMNS = {"customer_id": "string",
                    "product_id": "string",
                    "revenue": "double",
                    "date": "date"}

ADDITIONAL_INFORMATION_MANDATORY_COLUMNS = {"customer_id": "string",
                                            "date": "date"}

FLOW_INPUT_DATASETS = ['revenues_input', 'product_holdings_input', 'customer_data_input',
                      'balances_input', 'additional_information_input']

ENGINES_PRIORITY = ["SQL", "DSS"]

SQL_ENGINE_PREPARE_RECIPES = ['compute_revenues_renamed', 
                             'compute_product_holdings_renamed',
                             'compute_customer_data_renamed',
                             'compute_balances_renamed',
                             'compute_additional_information_renamed',
                             'compute_dates_month',
                             'compute_additional_information_prepared',
                             'compute_customer_data_prepared',
                             'compute_product_holdings_prepared',
                             'compute_product_holdings_portfolio',
                             'compute_balances_product_prepared_1',
                             'compute_balances_product_summary_customer_prepared',
                             'compute_transitions_share']

def group_template(index, column, column_type):
    return {'$idx': index,
              '$selected': False,
              'avg': True,
              'column': column,
              'concat': False,
              'concatDistinct': False,
              'concatSeparator': ',',
              'count': False,
              'countDistinct': False,
              'first': False,
              'firstLastNotNull': False,
              'last': True,
              'max': False,
              'min': False,
              'orderColumn': 'date',
              'stddev': False,
              'sum': False,
              'sum2': False,
              'type': column_type}