
Forecasts are generated by dynamically building and executing a time series forecasting pipeline based on user inputs from the [Project Setup](article:11). This includes selecting the target column, time step, forecast horizon, and (optionally) external features such as pricing data.

## 1. Model Initialization and Cleanup

Each forecast run  is creating a new **Time Series Forecasting ML task** using the selected input dataset and parameters (target column, time variable, time series identifiers)

## 2. Configuration of the ML Task

The ML task is automatically configured with the following settings:

- **Forecast horizon**: Set to the number of time steps defined in the setup
- **Metric to optimize**: The model selection process is based on a user-defined metric (e.g., MAPE, SMAPE, RMSE, etc.)
- **Algorithms**: Several models are trained:
  - Always: `Deep AR`, `Prophet`
  - If no pricing dataset is used: additional models such as `Seasonal LOESS`, `NPTS`, and `Simple Feedforward`
- **External features**: If pricing is provided, the features `base_price`, `sell_price`, and `discount_pct` are added to the model
- **Sampling strategy**: Full dataset sampling is used, and short time series are skipped automatically
- **Time unit and count**: Configured based on project variables to match the granularity of the dataset

## 3. Model Training and Selection

Once configuration is complete:
- All selected algorithms are trained
- The resulting models are compared based on the chosen optimization metric
- The best-performing model is automatically identified and selected for deployment

## 4. Model Deployment and Scoring

The selected model is then:
- **Deployed** to the flow as a saved model object
- **Used to create two recipes**:
  - A **Scoring recipe** to forecast future values
  - An **Evaluation recipe** to backtest the model on historical data

If external features (e.g., pricing) are used, the corresponding input dataset with those features is automatically selected.

The evaluation recipe is configured to use one historical value of the target variable and to produce only one forecast horizon, aligned with the backtest logic described in the official [DSS documentation on scoring with external features](https://doc.dataiku.com/dss/latest/machine-learning/time-series-forecasting/scoring.html#with-external-features).

## 5. Forecast Readiness

Once the best model is selected and deployed, the flow is automatically updated to include the scoring and backtesting steps.  
The dashboard is then configured to display the forecast results.

This seamless automation ensures that forecasts are immediately available for exploration, without requiring any manual adjustments to the flow or dashboard.
