<span id="version" style="color: grey; float: right">2.0.0</span>

# About this Wiki

This wiki contains the technical documentation on how to use the Demand Forecast solution, and how it works.

- One page is dedicated to the [Demand Explorer dashboard](article:12) and is targeted at business users: Demand Planners, Operational Managers, Marketing Managers, Business Analysts.
- The rest of this wiki is targeted at Data Analysts/Engineers/Scientists.

# Solution Scope

Forecasting demand accurately is critical for efficient planning—whether you're managing inventory, staffing, production, or budgets. The primary goal of this Demand Forecast Solution is to

- **Help Planners benefit from modern forecasting techniques** that improve accuracy compared to traditional spreadsheet-based tools.
- **Accelerate delivery for Data Analysts and Data Scientists** responsible for building and operationalizing forecasts.

This Solution is based on Time Series Forecasting (TSF). It is a strong fit when:

- You need **forecasts for fast- or medium-moving products or services** with consistent, time-based demand patterns.
- You want to support **recurring planning cycles** (e.g., weekly, monthly, quarterly).
- You’re looking to **replace or benchmark manual forecasts** to improve accuracy and reduce labor.
- You have **structured historical data**—ideally with multiple identifiers such as product, location, or customer.

> TSF is not ideal for demand mostly driven by external forecasts or irregular customer behavior.

# Capabilities

The Demand Forecast Solution delivers a powerful blend of usability, flexibility, and extensibility to support both strategic and operational forecasting needs.

## Quick and Guided Setup

- The **Project Setup** interface simplifies onboarding: select your input dataset, define Time Series Identifiers (TSIDs), choose a forecast horizon, and pick the evaluation metric to optimize.
- All other parameters use sensible defaults and can be fully customized later via the Visual Analysis environment.

## Powerful Forecasting, Easily Compared

- Benchmark a range of forecasting techniques — from classical statistical models to modern approaches like Facebook Prophet and Deep Learning architectures.
- Forecast accuracy is evaluated through backtesting, enabling confident model selection.

## Business-Ready Visualization

- A prebuilt **Demand Explorer** dashboard supports business validation of forecasts:
  - Line charts and tabular views
  - Aggregation by time step or TSID (e.g. product, store, channel)
  - Built-in filtering to navigate large product catalogs or geographies

## Model the Impact of Pricing

- Optionally include driver variables like **price** and **promotions**, to improve forecast relevance and accuracy.

## Compare to Legacy Forecasts

- Evaluate the value-add of the Solution by comparing new forecasts with those produced by your existing forecasting systems over the same backtest period.

## Extensibility

The project is built for modification and extension:

- Join external signals (e.g. weather, macroeconomic indicators) to improve input features
- Trigger downstream analytics, such as inventory allocation optimization based on forecast output
- Leverage the Forecasting Model for outcome optimization use cases (e.g. dynamic pricing, promotion timing)

## Automation and Deployment

- Includes a prebuilt **Scenario** for rescoring, which can be extended with custom **Triggers** and **Reporters**
- Once configured, the project can be deployed to an **Automation Node** for seamless integration into production workflows

# Walkthrough

See [Case Study and Walkthrough](article:7), which lays out the typical steps to leverage the Demand Forecast Solution. It’s based on a real use case and links out to in-depth documentation at each stage.
