# Project Setup

The **Project Setup** allows users to configure the core parameters of the demand forecasting solution. It includes data selection, schema mapping, and forecast execution.

This configuration step automatically drives the structure of the flow. Based on the selected inputs and parameters, datasets are dynamically shared, recipes are generated, and downstream logic is adapted.

## Input Datasets

In this section, users select the **data preparation project** and the main **sales dataset** to be used for forecasting. The sales dataset must contain equispaced time series data with a consistent date column and quantity values.

Optional inputs include:
- A **legacy forecast dataset**, used for comparison in the dashboard
- A **pricing dataset**, which enables price-related external feature modeling

When provided, these datasets are automatically integrated into the flow with appropriate sync and join recipes.

## Column Mapping

Users define which column contains the **sales values** and optionally map one or more **Time Series Identifiers** (e.g., product, store, region). This enables segmentation of forecasts across multiple series.

The **date column** and **time step** are automatically inferred from the dataset.

## Forecasting Configuration

Users specify the **forecast horizon** (in time steps) and the **error metric** to optimize during model training. Once parameters are set, clicking **Run Now** launches the full forecasting process, including training, evaluation, and scoring.

A direct link to the **Demand Explorer** dashboard is provided to review forecast results.

---

For more details on how the forecast is generated and how each step behaves in the flow, see the [Generating Forecasts](article:3) article.