This section informs you about all the requirements needed to use this solution.

# Instance Requirements
This solution is only compatible on instances with  **Dataiku V13.5+**

# Code Environment
This solution has a dedicated code env named **solution_demand-forecast**.

The python version used is 3.10 and pandas 2.2
It's  basically the Visual Machine Learning and Visual Time series forecasting (CPU) set of packages from Dataiku:
>Jinja2>=2.11,<3.2
MarkupSafe<2.2.0
Werkzeug<3.1
cloudpickle>=1.3,<1.6
flask>=1.0,<2.3
gluonts>=0.8.1,<0.17
itsdangerous<2.1.0
lightgbm>=4.6,<4.7
mxnet>=1.8.0.post0,<1.10
numpy<1.27
pmdarima>=1.8.5,<2.1
prophet>=1.1.1,<1.2
scikit-learn>=1.0,<1.6
scikit-optimize>=0.7,<=0.10.2
scipy>=1.13,<1.14
statsmodels>=0.12.2,<0.15
xgboost>=2.1,<2.2

# Volume Requirements
Time Series Forecasting (TSF) works by identifying patterns in historical data—seasonality, trends, or recurring fluctuations. To produce reliable forecasts, the underlying data must meet certain quality criteria:

- **Consistent Sales History**
  - TSF assumes that demand has been observed regularly over time. For each combination of **Time Series Identifiers (TSIDs)** (e.g., ``product_id``, ``store_id``), the sales signal must be continuous—not sporadic or irregular.
  - Sparse or highly erratic sales histories (common with slow-moving SKUs) often lack the structure needed to train meaningful forecasting models.
- **Minimum History Length**
  - This Solution uses Dataiku's native Time Series Forecasting engine, which enforces a `minimum number of observations per time series <https://doc.dataiku.com/dss/latest/machine-learning/time-series-forecasting/settings.html#minimum-required-length-per-time-series>`_. Cold-start products without sufficient history cannot be forecasted using this method.
- **Uncapped Demand**
  - The model assumes that historical sales reflect true demand, not constrained by stockouts or supply limitations.
  
# Data Storage Requirements

The **Demand Forecast** Dataiku Application is designed to work efficiently with various storage systems. It has been tested and validated on the following data connections:

- **Filesystem**
- **Snowflake**
- **AWS S3**
- **BigQuery**
- **PostgreSQL**

These connections support the full functionality of the application, including model training, scoring, automation, and dashboard interactivity.

> ⚠️ For any other data storage systems, usage is considered **experimental** and may require additional validation or customization. Proceed at your own risk.

## Customization Support

If your organization uses a different data storage backend or encounters compatibility issues, our team can provide roll-out and customization services on demand to ensure optimal integration with your infrastructure.
