AVAILABLE_ISOCHRONES_APIS = ["open_route_service", "here"]
ISOCHRONES_APIS_WITH_PYTHON_CLIENT = ["open_route_service"]
STARTER_PROJECT_VARIABLES = {isochrone_api:dict() for isochrone_api in AVAILABLE_ISOCHRONES_APIS}
WEBAPP_COLUMNS_TO_DROP = [
    'location_identifier',
    'isochrone_type',
    'distance_customer_location',
    'isochrone_id',
    'isochrone_label',
    'isochrone_data',
    'geo_point',
    'city',
    'department',
    'region',
    'country_iso'
]
OVERPASS_POI_TYPES = ["node"]
POINTS_OF_INTEREST_SCHEMA = ["poi_id", "poi_belonging_location",
                             "isochrone_type", "poi_type",
                             "poi_center", "poi_lat",
                             "poi_lon", "poi_geo_point",
                             "tags", "poi_nodes"]
CAR =  "car"
TRUCK = "truck"
PEDESTRIAN = "pedestrian"
BICYCLE = "bicycle"
PUBLIC_TRANSPORT = "public"
TRANSPORTATION_MODES_RENAMINGS = {
    "open_route_service":{
        "driving-car": CAR,
        "driving-hgv": TRUCK,
        "foot-walking": PEDESTRIAN,
        "foot-hiking": PEDESTRIAN,
        "cycling-regular": BICYCLE,
        "cycling-road": BICYCLE,
        "cycling-mountain": BICYCLE,
        "cycling-electric": BICYCLE
    },
    "here":{
        "car": CAR,
        "truck": TRUCK,
        "pedestrian": PEDESTRIAN
    }
}
GEOJSON_POLYGON_STARTER = {
        "type": "Feature",
        "properties": {},
        "geometry":{
            "type": "Polygon",
            "coordinates":[
                [
                ]
            ]
        }
    }
USE_KD_TREE_INDEXING = True
KD_TREE_DEFAULT_NEIGHBORS = 100
SUCCCESSIVE_EXCLUSIONS_STOPPING = 20