import numpy as np
import re
from .config import STARTER_PROJECT_VARIABLES, TRANSPORTATION_MODES_RENAMINGS, AVAILABLE_ISOCHRONES_APIS

def from_minutes_to_seconds(minutes):
    return int(minutes * 60)

def from_seconds_to_minutes(seconds):
    return int(seconds/60)

def compute_identifiers_combinations(list_of_identifiers):
    identifiers_combinations = {}

    for loop_identifier in list_of_identifiers:
        identifiers_combinations[loop_identifier] = [identifier for identifier in list_of_identifiers \
                                                     if identifier != loop_identifier]

    return identifiers_combinations

def load_project_parameters(project):
    variables = project.get_variables()
    local_variables  = variables["local"]
    isochrones_api_to_use = local_variables.get("isochrones_api_to_use")
    isochrones_api_suffix = "_{}".format(isochrones_api_to_use)
    
    for variable_name in STARTER_PROJECT_VARIABLES.keys():
        local_variables[variable_name] = STARTER_PROJECT_VARIABLES[variable_name]
    
    local_variable_names = [key for key in local_variables.keys()] # list(local_variables)
    
    for variable_name in local_variable_names:
        
        if isochrones_api_suffix in variable_name:
            variable_value = local_variables[variable_name]
            isochrone_api_variable_name = re.sub(isochrones_api_suffix, "", variable_name)
            
            if isochrones_api_to_use is not None:
                local_variables[isochrones_api_to_use][isochrone_api_variable_name] = variable_value
                
                if "transportation_mode" in variable_name:
                    print(f"Managing {variable_name}")
                    transportation_mode_api = re.sub("transportation_mode_", "", variable_name)
                    if transportation_mode_api == isochrones_api_to_use:
                        main_transportation_mode = TRANSPORTATION_MODES_RENAMINGS[isochrones_api_to_use][variable_value]
                        local_variables["main_transportation_mode"] = main_transportation_mode
                    #local_variables.pop(variable_name, None)
                    del local_variables[variable_name]
                
                if "isochrones_attributes" in variable_name:
                    del local_variables[variable_name]
                    
            
        elif ("transportation_mode" in variable_name) or ("isochrones_attributes" in variable_name):
            del local_variables[variable_name]
        
        if variable_name == "isochrones_range_min":
            variable_values = [int(value) for value in local_variables[variable_name]]
            local_variables[variable_name] = variable_values
        if ((variable_name in AVAILABLE_ISOCHRONES_APIS) and (variable_name)!= isochrones_api_to_use):
            del local_variables[variable_name]
    
    if not "isochrones_attributes" in local_variables[isochrones_api_to_use].keys():
        local_variables[isochrones_api_to_use]["isochrones_attributes"] = []
        
    return local_variables

def label_isochrones_range_min(isochrones_range_min):
    return ["isochrone_{}_min".format(isochrone) for isochrone in isochrones_range_min]

def extract_isochrone_value(isochrone_type):
    return int(str.split(isochrone_type, "_")[1])

def prettify_isochrone_label(isochrone_label):
    isochrone_label = re.sub("_", " ", isochrone_label)
    isochrone_label = re.sub("isochrone", "Isochrone -", isochrone_label)
    return isochrone_label

def preprocess_customers_for_webapp(customers_df):
    customers_df = customers_df.loc[
        customers_df
        .groupby(['location_id', 'included_customer_id'])
        .isochrone_amplitude.idxmin()
    ]
    customers_df = customers_df.rename(columns={
        "included_customer_id": "id",
        "customer_id_denormalized": "customer_uuid",
        "location_id": "location_uuid"
    })
    return customers_df

def update_locations_customers_search_status(loop_percents, spent_time, index_loop, n_loop_combinations):
    loop_percent = 100*float(index_loop)/n_loop_combinations
    percent_to_exceed = loop_percents[0]
    if int(loop_percent) > percent_to_exceed:
        del loop_percents[0]
        log_message = "Iteration {}/{} ({}%) | Spent time : {} seconds.".format(index_loop,
                                                                           n_loop_combinations,
                                                                           loop_percent,
                                                                           spent_time)
    else:
        log_message = None
    return loop_percents, log_message