# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# -*- coding: utf-8 -*-
import dataiku
import pandas as pd, numpy as np
from dataiku import pandasutils as pdu

from distribution_spatial_footprint.utils import preprocess_customers_for_webapp
from distribution_spatial_footprint.config import WEBAPP_COLUMNS_TO_DROP


# Read recipe inputs
locations_customers = dataiku.Dataset("locations_customers")
locations_customers_df = locations_customers.get_dataframe()

columns_to_select = [col for col in locations_customers_df.columns if col not in WEBAPP_COLUMNS_TO_DROP]

webapp_customers_df = preprocess_customers_for_webapp(locations_customers_df[columns_to_select])

# Write recipe outputs
webapp_customers = dataiku.Dataset("webapp_customers")
webapp_customers.write_with_schema(webapp_customers_df)