# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# -*- coding: utf-8 -*-
import dataiku
import pandas as pd, numpy as np
from dataiku import pandasutils as pdu

# Read recipe inputs
locations_isochrones = dataiku.Dataset("locations_isochrones")
locations_isochrones_df = locations_isochrones.get_dataframe()

columns_to_select = [col for col in locations_isochrones_df.columns if not col.startswith("isochrone_")]
webapp_locations_df = locations_isochrones_df[columns_to_select]

webapp_locations_df = webapp_locations_df.rename(columns={
    "location_identifier": "id",
    "location_id": "location_uuid"
})
WEBAPP_LOCATIONS_IDENTIFIERS = ["location_uuid", "id"]
webapp_locations_df = webapp_locations_df[WEBAPP_LOCATIONS_IDENTIFIERS +
                                          [col for col in webapp_locations_df.columns
                                           if not col in WEBAPP_LOCATIONS_IDENTIFIERS]
                                         ]
# Compute recipe outputs from inputs
# TODO: Replace this part by your actual code that computes the output, as a Pandas dataframe
# NB: DSS also supports other kinds of APIs for reading and writing data. Please see doc.


# Write recipe outputs
webapp_locations = dataiku.Dataset("webapp_locations")
webapp_locations.write_with_schema(webapp_locations_df)