# Section presentation

The *Isochrones* section has the role to let you specify how you want to compute isochrones in the project. 
Everything that is set here sets what happens in the *isochrones_zone* ([See the corresponding wiki article](article:24)).
![dsf_isochrones_setup.png](DEcamF9Sm3Jd)

# Section interactions

## General parameters

### Isochrones API to use 
Choose here the isochrones API provider to use in the project ( [See the section associated to the isochrones API requirements](article:7))

### Time from your locations
Specify here the isochrones types (the time needed to reach isochrones boundaries, starting from the isochrones center) you want to compute: you can compute one or many of these isochrones *(on the example picture above, you can see that "Isochrones 5 min", "Isochrones 15 min" and "Isochrones 30 min" are tested)* .


## API Parameters
![isochrones_api_parameters.png](qclwUZZY3nKl)

### API key
The API key generated by your Isochrones API provider.

### Transportation mode
The means of transport used to compute the isochrones.

**Openrouteservice**
- Driving: 
  - Driving car.
  - Driving hgv (truck).
- Foot:
  - Foot walking.
  - Foot hiking.
- Cycling:
  - Cycling regular: uses a default set of speeds and road type preferences.
  - Cycling electric: uphill speed is not affected as much by the incline.
  - Cycling road: anything that is not a road surface (paving stone, asphalt etc.) is seen as a pushing section, but allows secondary and tertiary roads (other bike profiles these are avoided).
  - Cycling-mountain:  allows going over most surface types and tracks without defining as a pushing section.

More explanations provided on the Openrouteservice's [official documentation](https://github.com/GIScience/openrouteservice-docs/blob/master/README.md#waytype-speeds).

### Isochrones attributes 
The additional information to extract from the isochrones.
**Openrouteservice**

- Population living in isochrones: the population count contained in the isochrone. According to Openrouteservice:
>  The dataset, which makes this possible, is published by the European Commission in their [Global Human Settlement Program](https://ghsl.jrc.ec.europa.eu/about.php). It features 250 m x 250 m cell size across the globe and is the finest grained dataset of its kind.
- Isochrones areas: The isochrone area (in squarred km in this project).
- Isochrones reachfactor: A reachability score between 0 and 1. According to Openrouteservice:
>   The maximum reach factor would be  achieved by travelling as the crow flies at maximum speed in vacuum without obstacles, naturally it can never be 1. The availability of motorways however produces a higher score over normal roads.