You will find  **detailed documentation on the Compute Resource Usage (CRU) logs [[here](https://doc.dataiku.com/dss/latest/operations/compute-resource-usage-reporting.html)].** 

 **Those logs monitor the CPU and Memory usage**  of  **local**  and  **kubernetes**  logs. For  **SQL**  computations, it provides the execution time (which might include waiting time). For each process, it produces : 
 - a trace when a process starts : ```compute-resource-usage-start```
 - a trace every minute over the duration of the process  : ```compute-resource-usage-update```
 - a trace when it ends : ```compute-resource-usage-complete```
 Therefore the minimal unit of time measure that you will see in this project is aggregation over minutes.
 
## Where can I find the CRU logs?
CRU logs are natively gathered through the [audit centralization mechanism](https://doc.dataiku.com/dss/latest/operations/audit-trail/index.html) and stored in the  **audit logs that you can find in your datadir/run/audit/** . 
However, we strongly advise you to install an [Event server](https://doc.dataiku.com/dss/latest/operations/audit-trail/eventserver.html) and configure your auditing target's destination to point to your Event server (Administration > Settings > Auditing). It comes with several benefits : 
  - Keep the history of the logs (the default audit directory is regularly flushed).
  - You can monitor all your nodes with the same event server and group the analysis into the same dashboard.
  - Event server allows dispatching the logs in different folders according to their topics and date. It will help load less data into the flow and partition easily your datasets. 
  
## How can I monitor the Kubernetes processes?
Go to Administration > Settings > Misc and enable periodic reporting. You need to restart DSS for these changes to take effect.
The platform will then periodically (every minute) query each Kubernetes cluster for a list of pods and the current resource consumption of each pod, and will emit a dedicated CRU message containing the list of pods with their current resource consumption.



