 _For detailed documentation on  **Compute Resource Usage (CRU) logs**, refer to the official Dataiku documentation [[here](https://doc.dataiku.com/dss/latest/operations/compute-resource-usage-reporting.html)]. _ 
 
These logs monitor **CPU and Memory usage for local and Kubernetes processes**. For SQL computations, they report the execution time (which may include waiting time).

For each process, it produces : 
- `compute-resource-usage-start`: emitted when a process begins.
- `compute-resource-usage-update`: emitted every minute during the process's execution.
- `compute-resource-usage-complete`: emitted when a process ends.

Consequently, the smallest unit of time measure observed in this project will be aggregations over minutes.
 
## Where can I find the CRU logs?
CRU logs are natively collected via the [audit centralization mechanism](https://doc.dataiku.com/dss/latest/operations/audit-trail/index.html) and are stored within the  **audit logs located in your `datadir/run/audit/` directory** . 
However, we strongly advise you to install an [Event Server](https://doc.dataiku.com/dss/latest/operations/audit-trail/eventserver.html) and configure your auditing target's destination to point to your Event Server (<span style="color:#077abf">Administration > Settings > Auditing</span>). 
It comes with several benefits : 
  - **Historical Retention:** Retain log history, as the default audit directory is regularly flushed.
  - **Centralized Monitoring:** Monitor all your DSS nodes using a single Event Server, consolidating analysis into a unified dashboard.
  - **Efficient Data Loading:** Event Server dispatches logs into different folders based on topic and date, which helps load less data into the flow and facilitates easy partitioning of datasets.
  
## How can I monitor the Kubernetes processes?
Navigate to <span style="color:#077abf">Administration > Settings > Misc</span> and enable periodic reporting. A DSS restart is required for these changes to take effect.
Once enabled, the platform will periodically (every minute) query each Kubernetes cluster to retrieve a list of pods and their current resource consumption, then emit dedicated CRU messages.



