<div class="alert">
We highly encourage our users to carefully review this agentic framework, including its architecture and prompts, revise the framework as needed, and thoroughly test its performance with users' preferred LLMs before implementation.
</div> 

# Version
This project is compatible with  **Dataiku 14.3+** .

# LLM requirements

This project requires an LLM connection to power the agents, tools and the Agent Hub. 
We have tested this solution with the following LLMs, but we do not ensure their performance: 
- Google Gemini 2.5 (pro and flash)
- Open AI GPT-5 and GPT-4o
- Anthropic Claude Sonnet 4

Users must do their own testing to determine which LLMs work best for their needs.

# Code Environment
Project Python recipes uses the code env **solution_dynamic-selling-assistant**.

The python version used is  **3.11**  (with pandas 2.2)

Required packages for this code environment are: 
> MarkupSafe<2.2.0
Jinja2>=2.11,<3.2
cloudpickle>=3,<4
flask>=1.0,<2.3
itsdangerous<2.1.0
lightgbm>=4.6,<4.7
scikit-learn>=1.1,<1.6
scikit-optimize>=0.7,<=0.10.2
scipy>=1.13,<1.14
statsmodels>=0.12.2,<0.15
Werkzeug<3.1
xgboost>=2.1,<2.2
gluonts[torch]>=0.8.1,<0.17
pmdarima>=1.8.5,<2.1
prophet>=1.1.1,<1.2
numpy<1.27
mxnet>=1.8.0.post0,<1.10  # Mxnet is deprecated. It will be retired in the next major DSS version.
torch>=2,<2.8
--extra-index-url https://download.pytorch.org/whl/cpu

An internal code environment is also needed:  retrieval augmented generation. Please refer to Dataiku's [documentation](https://doc.dataiku.com/dss/13/generative-ai/knowledge/initial-setup.html)


# Project Installation #
User can directly launch the [Dynamic Selling Assistant](web_app:ud5isHW) web application to begin interacting with the agent. No further installation is required.

# Email Connection 
To use the email sender tools, the agent needs to have access to an STMP connection. The settings can be defined in  **Administration**  >  **Notifications & Integrations**  >   **Salesforce login with Username-Password** >  **Messaging channels** >**Mail (SMTP) channel**. 

To generate a  **password**  to sign in within the Mail (SMTP) channel, use this [link](https://support.google.com/mail/answer/185833). 

# Plugins
This project requires:
- [SQL Question Answering Agent Tool ](https://doc.dataiku.com/dss/13/generative-ai/agents/tools/sql-question-answering.html)**V1.1.3+**.
- [Agent Hub](https://doc.dataiku.com/dss/latest/agents/agent-hub.html) **v1.0.1+**
