# Scenario 1: Sales Assistant
 As a Regional Sales Manager for an international retail company, I aim to adapt my sales strategy to the recent market evolution and optimize my inventory management. This requires having a correct and up-to-date understanding of my inventory levels, product dynamics, an assessment of demand forecast, and markdown impact.

 **Supply situation analysis** : The procurement team uses the agent to provide information on the current inventory levels, total forecasted monthly demand, supply gap or to identify top/worst selling products.
 
 **Decision Support** : The agent can provide recommendations on when to replenish inventory, how much to order, how long the current inventory levels will last, and identify cross-selling opportunities.
 
 **Impact assessment** : Once the Regional Sales Manager has chosen a strategy, they can back their decisions with an impact assessment of markdown campaigns and supply gap analysis.

## Outcome :
The agent assists the Regional Sales Manager in adjusting the sales strategy to recent market developments and making informed decisions by leveraging daily store data. This helps optimize inventory management and preempt shortages of top-selling products. 

## User Story
 **Persona** : A Regional Sales Manager at a global retail company, having to manage prices, inventories, and products for multiple stores.

 **Task**: Minimize unsold stock through appropriate markdowns while ensuring stores do not run out of in-demand products to maximize revenue.
 
 ## Example questions
1. What is the supply situation for our 3 best-selling products?
2. For the products with a critical level, are there any stores particularly impacted?
3. What would be the impact of a 20% discount on our best-selling product?

# Scenario 2: Daily Inventory Processing to Flag Critical Situations
As a Regional Sales Manager working for an international retail company, I want to have an up-to-date view of the evolution of my stores' inventory levels and sales performance. Particularly, I want key elements to be summarized and critical situations flagged. 

 **Flagging Critical Supply Situations** : Daily inventory levels and demand forecasts are processed overnight to identify products with a supply gap or an oversupply. If critical, an email is sent in the morning to the regional sales manager, summarizing 
 
 **Weekly Digest** : The agent sends an email to the Regional Sales Manager with a weekly digest of the supply situation of their stores. The Regional Sales Manager can choose what KPIs and analyses are showcased in this summary and its frequency (daily, weekly, bi-weekly, monthly...). 

## Outcome :
Without interacting with the agent, the Regional Sales Manager has an up-to-date view of their stores and receives alerts when critical situations are detected. This helps to preempt shortages of top-selling products and keep an accurate view of the stores managed.

## Example of a situation analysis for a single garment :
![Supply_Situation.png](PPWVUdVZgoCk)
