# Overview 
This project is prepackaged with different datasets on [Sales and Demand Forecast](flow_zone:s4EOxWD), [Customer Information](flow_zone:TaPoHVn) and [Product Recommendation](flow_zone:default).

Furthermore, this project includes five agents: 
 - A main [Store Assistant Agent](saved_model:XoFPzwEm), that calls the two other agents and sends emails
 - [Customer Agent](saved_model:DUeYkBfU), [Product Agent](saved_model:8gKEfYwY) and [Sales Agent](saved_model:DDiXhIwO) connected to their respective datasets using the SLQ tool plugin.
 - A [Markdown Agent](saved_model:n0gLkDhT), that has access to the [markdown_features](dataset:markdown_features) dataset that includes product characteristics, historical sales metrics, price & discount history and seasonality information. These are leveraged by the [Markdown_model](saved_model:DEMANDFORECASTSALESASSISTANT.rQTmjKBd) to support markdown analysis and price optimization decisions. Further information on how the model operates can be found on its [Wiki](article:DEMANDFORECASTSALESASSISTANT.85).

# Flow zone #
The flow zone is structured around the three agents, the datasets and the models they're using. In this project, no data preparation is done, but to adapt the demo to the user's file, some data preparation of the inventory and sales data may be needed.
### Answer datasets and pre-built questions
These zones include the orchestrating agent, the chat history with the agent, the user profiles and a set of pre-built questions to ask the agent. This set of questions is by a daily scenario to automatically send a daily report by email on sale recommendation for top/worst selling products or products with an important demand change.
![Store_Assistant_Agent.png](XchPvEQgIsTY)

### Data Query
The data query zone contains the Data Query Agent and all the documents that this agent has access to. These datasets contain information on:

- Personalized product recommendations for customers used for targeted marketing
- Sales and Demand forecast
 - Product description (IDs, product family and universe, collection)
  - Weekly demand forecast
  - Total number of units sold and revenue
- Customer profile information including
 - Gender
 - Customer Lifetime Value metrics (historical and predicted), clusters and predictions
 - RFM (Recency, Frequency, Monetary) segmentation
 - Transaction behavior (number of transactions, total purchases)
 - Customer segmentation labels (e.g., "Champions," "Can't lose them," "Hibernating")
![Data_Query_Agent.png](0KmFkzWJ9ObZ)

### Markdown
The Markdown flow zone contains the Markdown Agent, Markdown model and the [markdown_features](dataset:markdown_features) dataset that includes:
- Product characteristics
- Historical sales metrics
- Price & discount history
- Seasonality information

![Markdown_Agent.png](yXgzaINbblmB)