# Segmentation Manager
The [Segmentation Manager](web_app:cB81HJ2) web application simplifies managing and updating segmentation results. Users can quickly find existing segmentation sessions, review and compare segmentation updates, and save new versions seamlessly. The intuitive interface guides users through the update process, and integrated visualizations help explain the outcomes.

The app ensures that the updated segmentation remains consistent with the original settings, preserving the parameters while allowing for adjustments as the data evolves. Users can export updated results or save them back to the Dataiku flow for future analysis, ensuring that segmentation strategies remain dynamic and relevant.

## Segmentation Session Tab
![9.png](vJcEzMgibNrM)
- Users can search and select an existing segmentation session from the active sessions list. Each session is represented as a card displaying essential details like session name, dataset, user, date, and method. Tooltips provide additional descriptions and features used.
- Users can initiate the update process by selecting a session. The selected session's information is highlighted, and the right panel displays a table showing the last version's data.
- Users can click "Update" to apply the same segmentation settings to the current version of the dataset, which exists in the Dataiku flow. Note that only "active" sessions can be updated since these are the latest output results. 
- Users can Activate an old segmentation version (similar to ML models) by selecting "Make Active" button. 
- Users can Delete segmentation session and clean unecessary or old versions by clicking "Delete". Note that "active" sessions cannot be deleted as they are connected the latest output data. However user can activate a different version and delete any session of interest. 
- If the dataset structure has changed or there are updates, the application processes and compares the segmentation results for the records that changed segmentation along with a Sankey diagram to visualize changes.

## Insights Tab

- Users can enter metadata descriptions and click "Save" to update the session information, storing it as a new version in Dataiku. The "Export" button allows users to download the updated segmentation results as a CSV file.
- Visualizations, including:
 - Segmentation Insights: Displays the distribution of records in each segment and the importance of features contributing to segmentation, helping users understand changes and data behavior.
 - Feature Distribution Analysis: Shows distribution comparisons for selected features and allows users to explore average values across segments using a heatmap.
 

# Connection to Dataiku Flow
## Session Management
The app pulls active sessions and their metadata from Dataiku's [metadata_dataset](dataset:metadata_dataset) and [output_data_folder](managed_folder:YIM9iOet). Each session is associated with a dataset and various parameters like segmentation method, features, and segment names. The application checks for an updated version of the original dataset in the Dataiku flow.
## Dataset Integration and Processing:
When users select a session to update, the application retrieves the dataset from Dataiku, ensuring it matches the original dataset name. It then applies the same filtering and segmentation parameters as the selected session. Segmentation updates use saved models (K-Means) or rules (Rule-Based), leveraging Dataiku's integration for seamless execution. Feature weights and preprocessing are applied directly, ensuring consistent segmentation logic.
## Save and Export Functionality:
Upon saving, a new record is created in the [metadata_dataset](dataset:metadata_dataset), storing the updated segmentation session's details, including a new version number. The updated dataset is also saved back into the Dataiku flow. Exported CSV files are generated directly from the updated results, allowing users to download data for external use.