This section informs you about all the requirements needed to use this solution.

# Instance Requirements
This solution is only compatible on instances with  **Dataiku DSS V12.1+**

## Code Environment
Project python recipes uses the code env **solution_factories-electricity-co2-forecasting**.


The code environment  requires 2 packages for the solution itself and 14 for the visual time series forecasting: 
>nbformat>=4.2.0
plotly-express>=0.4.1
MarkupSafe<2.1.0
cloudpickle>=1.3,<1.6
flask>=1.0,<1.1
itsdangerous<2.1.0
Jinja2>=2.11,<2.12
lightgbm>=3.2,<3.3
scikit-learn>=0.20,<0.21
scikit-optimize>=0.7,<0.8
scipy>=1.2,<1.3
statsmodels==0.12.2
xgboost==0.82
gluonts==0.10.4
pmdarima==1.2.1
mxnet==1.8.0.post0

## Plugins

This project rely on 3 plugins: 

 - [Geocoder Plugin](https://www.dataiku.com/product/plugins/geocoder/): If your input dataset contains addresses, instead of geocoded locations, you will need to install this plugin on your DSS instance.

 - [Time Series preparation](https://www.dataiku.com/product/plugins/timeseries-preparation/)
 
 - [CO2 Conversion plugin](https://www.dataiku.com/product/plugins/co2-converter)


### Installing a DSS plugin
[Learn how to install a DSS plugin](https://doc.dataiku.com/dss/latest/plugins/installing.html)

### Using the ElectricityMap API

If you want to convert electricity consumption for locations other than France, you can use [ElectricityMaps](https://app.electricitymaps.com/) API. You can get using the [contact form](https://www.electricitymaps.com/contact-us?utm_source=dataiku).
