This section informs you about all the requirements needed to use this solution.

# Instance Requirements
This solution is only compatible on instances with  **Dataiku DSS V12.1+**

## Code Environment
Project python recipes uses the code env **solution_factories-electricity-co2-forecasting**.


Required packages for this code env are: 
>Jinja2>=2.11,<3.2
MarkupSafe<2.2.0
Werkzeug<3.1
cloudpickle>=3,<4
flask>=1.0,<2.3
gluonts>=0.8.1,<0.17
itsdangerous<2.1.0
lightgbm>=4.6,<4.7
mxnet>=1.8.0.post0,<1.10#Mxnetisdeprecated.ItwillberetiredinthenextmajorDSSversion.
nbformat>=4.2.0
numpy<1.27
plotly-express>=0.4.1
pmdarima>=1.8.5,<2.1
prophet>=1.1.1,<1.2
scikit-learn>=1.1,<1.6
scikit-optimize>=0.7,<=0.10.2
scipy>=1.13,<1.14
statsmodels>=0.12.2,<0.15
xgboost>=2.1,<2.2

## Plugins

This project rely on 3 plugins: 

 - [Geocoder Plugin](https://www.dataiku.com/product/plugins/geocoder/): If your input dataset contains addresses, instead of geocoded locations, you will need to install this plugin on your DSS instance.

 - [Time Series preparation](https://www.dataiku.com/product/plugins/timeseries-preparation/)
 
 - [CO2 Conversion plugin](https://www.dataiku.com/product/plugins/co2-converter)


### Installing a DSS plugin
[Learn how to install a DSS plugin](https://doc.dataiku.com/dss/latest/plugins/installing.html)

### Using the ElectricityMap API

If you want to convert electricity consumption for locations other than France, you can use [ElectricityMaps](https://app.electricitymaps.com/) API. You can get using the [contact form](https://www.electricitymaps.com/contact-us?utm_source=dataiku).
