A version of this Solution that incorporates GenAI capabilities is available for download [here](https://downloads.dataiku.com/public/dss-samples/SOL_FINANCIAL_FORECASTING_GENAI/). It leverages LLM recipes in the flow as well as a webapp to interact with a generated report. If you are interested in using the GenAI version of this Solution the Technical Requirements can be found below. It is, however, recommended that you reach out to your account team to qualify and support usage.

Large Language Models (LLMs) has recently opened a new breadth of possibilities in terms of generating Natural Language content following instructions. Two uses of this technology are highlighted in this project, the first one enables to write an initial report from some given data and an example and the second one gives the possibility to chat directly with the LLM to edit and improve the initial version of the report.

# Simple Prompting

![Report Generation.png](ZlKkGloI9xlA)

The initial creation of the report happens in the flow, leveraging the [Prompt Recipe and the Prompt Studio](https://knowledge.dataiku.com/latest/ml-analytics/gen-ai/concept-prompt-studio.html) from Dataiku. They connect to a LLM configured in the connections and allows to experiment on some prompts and then apply it on a dataset. Hence, the user is able to leverage the power of LLMs in a complete no-code approach.

The prompt provides instructions to the LLM along with an example of the expected output and the data needed to generate this output. This technique can be improved using few-shots context learning, where a series of pairs input-output are given to the LLM in the context window.

# Chat

![Financial Forecasting GenAI.gif](iDsCNkPEonM2)

These LLMs also allow to interact through a chat interface. This is what is displayed in the webapp where the user can edit iteratively edit the report through instructions. Depending on the size of the context window, a more or less long history can be kept in memory to answer the instructions as well as possible.

This feature was developed using code and connecting to one of the LLM configured in the connections in an technology-agnostic way. It leverages the development framework described [here](https://developer.dataiku.com/latest/tutorials/webapps/code-studio/index.html).

# Technical Requirements

The solution runs on Dataiku  **12.4+** 

A **Python 3.8+** code environment called  **solution_financial-forecasting-gpt**  is needed, it contains the following packages that are used in the python functions:
>pmdarima==2.0.2
urllib3<2
PyMuPDF==1.18.19
regex==2022.10.31
pyldavis==3.2.2
nltk==3.6.7
scikit-learn==0.24.2
wordcloud==1.8.2.2
langchain==0.0.349
openai==1.3.8
numpy==1.21.6
transformers==4.18.0
torch==1.13.1
Flask>=0.9
git+https://github.com/dataiku/solutions-contrib.git@main#egg=webaiku&subdirectory=bs-infra
dataiku-api-client==12.4.0
python-dotenv>=0.19.0

