from flask import Blueprint, jsonify, request
from .service import FFGPT
import os

print(os.getenv("DKU_CURRENT_PROJECT_KEY"))

fetch_api = Blueprint("fetch_api", __name__, url_prefix="/api")
ff = FFGPT()

@fetch_api.route("/business_units", methods=["GET"])
def get_business_units():
    return jsonify(ff.business_units)

@fetch_api.route("/saved_folder_url", methods=["GET"])
def get_saved_folder_url():
    return ff.get_saved_folder_url()

@fetch_api.route("/generate_email", methods=["POST"])
def generate_email():
    print(request.get_json())
    business_unit = request.get_json()["business_unit"]
    email = ff.generate_email(business_unit=business_unit)
    return jsonify({"email": email, "success_error":1})

@fetch_api.route("/send_instruction", methods=["POST"])
def send_instruction():
    request_json = request.get_json()
    instruction = request_json["query"]
    history = request_json["history"]
    email, success_error = ff.send_message(instruction, history)
    return jsonify({"email": email, "success_error": success_error})

@fetch_api.route("/save_report", methods=["POST"])
def save_report():
    email_content = request.get_json()["email"]
    business_unit = request.get_json()["business_unit"]
    is_email_sent = ff.save_report(
        email_content=email_content, business_unit=business_unit
    )
    return jsonify({"success": is_email_sent})