This case study offers a walkthrough of the solution using a combination of manually generated data, and data pulled from public Kaggle datasets simulating lead data. 

# User Story

Lead Scoring provides business value by allowing companies to prioritize their sales efforts, increase efficiency, improve sales and marketing alignment, and ultimately increase revenue. Insights gained include understanding which leads are most likely to convert, what the projected business value of these leads is, and tailoring marketing and sales strategies to their needs. Teams and divisions that can benefit from lead scoring include sales, marketing, and customer success teams.

# Data

This article outlines the entire process, from data input to obtaining the final analyses, which involves  **four pre-prepared datasets** :

 - A  **touchpoint dataset**  including all marketing interactions that exist for each lead.
 - A  **historical lead information dataset**  about past leads and the information of whether they converted into clients or not. 
 - A  **to score lead information dataset**  including static information about actual leads we want to score. 
 - A  **customer value dataset**  including a list of actual customers with their respective values and static information. In this use case, we used a rolling sum of revenue over the last 12 months to compute the column in a distinct preparation project. 
 
The following  **optional columns**  were added to the input data : 
- Lead touchpoint: campaign_frequency
- Historical lead information: region, gender, income, age_category_at_creation
- To score lead information: region, gender, income, age_category_at_creation
- Customer value: region, gender, income, age_category_at_creation

It is important to note that any optional column(s) included in the Customer Value Dataset must also be present in the Historical Lead Information and To Score Lead Information Datasets. Additionally, at least one optional column must be added to both the Historical Lead Information and To Score Lead Information Datasets, as well as the Customer Value Dataset, to ensure the construction of a customer value prediction model with an adequate number of features.

[Link to Data Model page for additional information](article:28)


# Insights

Upon completion of data ingestion and flow creation, users gain access to a comprehensive dashboard consisting of five pages. These pages offer insights into historical data, identify the leads most likely to convert, and project the potential business value of those leads.

