from dku_utils.projects.project_commons import get_current_project_and_variables
from dku_utils.projects.recipes.join_recipe import compute_join_recipe_computed_column_settings

FLOW_INPUT_DATASETS = [
    "demand_forecast_features",
    "product_override",
    "product_strategy",
    "product_inventory",
    "product_cost",
    "product_markdown_constraints",
    "product_to_markdown",
    "product_balance_parameters",
]
FALLBACK_DATASETS = [
    "available_discount",
    "demand_no_discount_predicted",
    "demand_same_discount_predicted",
    "initial_product_strategy",
    "predicted_demand",
]

FALLBACK_CONNECTIONS = {
    "available_discount": ["compute_available_discount_prepared"],
    "demand_no_discount_predicted": ["compute_sales_x_features_zero_scored_prepared"],
    "demand_same_discount_predicted": [
        "compute_sales_x_features_reference_static_scored_prepared"
    ],
    "initial_product_strategy": [],
    "predicted_demand": ["compute_predicted_demand_prepared"],
    "demand_forecast_features": [
        "compute_transactions_by_article_id",
        "compute_sales_x_features_joined_by_product_id",
        "compute_demand_forecast_features_filtered",
        "compute_demand_forecast_features_on_scope",
    ],
}

FLOW_INPUT_DATASETS_TO_PRESERVE = ["writeback_webapp"]


project, variables = get_current_project_and_variables()

default_max_markdown_app = variables["standard"]["default_max_markdown_app"]
default_min_markdown_app = variables["standard"]["default_min_markdown_app"]
default_profit_balance_app = variables["standard"]["default_profit_balance_app"]
default_volume_balance_app = variables["standard"]["default_volume_balance_app"]
default_strategy_app = variables["standard"]["default_strategy_app"]

CONFIGURATION_DATA_SCHEMA = {
    "product_strategy": {
        "columns": ["optimization_strategy"],
        "computed": [
            compute_join_recipe_computed_column_settings(
                "optimization_strategy", "string", f"'{default_strategy_app}'"
            )
        ],
    },
    "product_balance_parameters": {
        "columns": ["profit_parameter", "volume_parameter"],
        "computed": [
            compute_join_recipe_computed_column_settings(
                "profit_parameter", "double", f"{default_profit_balance_app}"
            ),
            compute_join_recipe_computed_column_settings(
                "volume_parameter", "double", f"{default_volume_balance_app}"
            ),
        ],
    },
    "product_cost": {
        "columns": ["product_cost", "product_base_price"],
        "computed": [
            compute_join_recipe_computed_column_settings(
                "product_cost", "double", "-1"
            ),
            compute_join_recipe_computed_column_settings(
                "product_base_price", "double", "-1"
            ),
        ],
    },
    "product_markdown_constraints": {
        "columns": ["min_markdown", "max_markdown"],
        "computed": [
            compute_join_recipe_computed_column_settings(
                "min_markdown", "double", f"{default_min_markdown_app}"
            ),
            compute_join_recipe_computed_column_settings(
                "max_markdown", "double", f"{default_max_markdown_app}"
            ),
        ],
    },
    "product_override": {
        "columns": ["override_flag", "override_value"],
        "computed": [
            compute_join_recipe_computed_column_settings(
                "override_flag", "string", "'False'"
            ),
            compute_join_recipe_computed_column_settings(
                "override_value", "double", "0.0"
            ),
        ],
    },
}
