from dku_utils.projects.project_commons import get_current_project_and_variables, get_project_and_variables
from dku_utils.projects.recipes.group_recipe import (
    define_group_recipe_aggregations,
    override_group_recipe_output_column_names,
)
from dku_utils.projects.recipes.recipe_commons import (
    adapt_recipe_engine_to_priority_and_availability,
    update_recipe_ouput_schema,
)


def group_display():
    project, variables = get_current_project_and_variables()

    recipe_name = "compute_display_table_by_product_id"
    project_demand, variables_demand = get_project_and_variables(
        variables["standard"]["demand_forecast_project_key_app"]
    )
    granularities = variables_demand["standard"]["timeseries_identifiers_columns"][1:-1]
    column_aggregations_mapping = {
        "product_cost": ["max"],
        "base_price": ["avg"],
        "sell_price": ["avg"],
        "min_markdown": ["max"],
        "max_markdown": ["max"],
        "profit_parameter": ["max"],
        "volume_parameter": ["max"],
        "stock": ["sum"],
        "forecasted_volume": ["sum"],
        "revenue": ["sum"],
        "total_profit": ["sum"],
        "lost_sales": ["sum"],
        "lost_profit": ["sum"],
        "discount_pct_weigted": ["sum"],
        "optimization_strategy":["max"],
        "volume_uplift_weighted":"sum",
        "profit_uplift_weighted":"sum"
    }
    column_name_overrides = {
        "product_cost_max": "product_cost",
        "base_price_avg": "base_price",
        "sell_price_avg": "sell_price",
        "min_markdown_max": "min_markdown",
        "max_markdown_max": "max_markdown",
        "profit_parameter_max": "profit_parameter",
        "volume_parameter_max": "volume_parameter",
        "stock_sum": "stock",
        "forecasted_volume_sum": "forecasted_volume",
        "revenue_sum": "revenue",
        "total_profit_sum": "total_profit",
        "lost_sales_sum": "lost_sales",
        "lost_profit_sum": "lost_profit",
        "optimization_strategy_max":"optimization_strategy"
    }
    
    for granularity in granularities:
        column_aggregations_mapping[granularity] = ["max"]
        column_name_overrides[f"{granularity}_max"] = f"{granularity}"
        
    define_group_recipe_aggregations(
        project,
        recipe_name,
        column_aggregations_mapping,
        bool_compute_global_count=False,
    )
    override_group_recipe_output_column_names(
        project, recipe_name, column_name_overrides
    )

    adapt_recipe_engine_to_priority_and_availability(project, recipe_name)
    update_recipe_ouput_schema(project, recipe_name)
