import axios from "../ApiHelper";

export interface ElasticityData {
  discounts: Array<number>,
  rows: Array<string>
}
export interface ApiResponse<T> {
  data: T,
  status: number;
  message: string;
}

export let API = {
  getDatasetName: (name: String): Promise<any> => axios.get("/api/name", {
    params: {
      dataset: name
    }
  }),
  getDatasetSchema: (dataset_name: String): Promise<any> => axios.post("/dataset/get_schema", {
    dataset_name: dataset_name,
  }),
  getDatasetData: (name: String, project: String): Promise<any> => axios.get("/api/dataset_data", {
    params: {
      dataset: name,
      project: project
    }
  }),
  getDatasetColumns: (name: String, project: String): Promise<any> => axios.get("/api/dataset_columns", {
    params: {
      dataset: name,
      project: project
    }
  }),
  getSummary: (store: String, project: String): Promise<any> => axios.get("/api/summary", {
    params: {
      store: store,
      project: project
    },
  }),
  getDataset: (dataset_name: String, chunksize: String, chunk_index: String): Promise<any> => axios.post("/dataset/get", {
    dataset_name: dataset_name,
    chunksize: chunksize,
    chunk_index: chunk_index,
  }),
  sendUpdateRows: (rows: any[], username: String): Promise<any> => axios.post("/api/updaterow", {
    rows: rows,
    username: username
  }),
  getUsername: () => axios.get("/api/user", {
  }),
  getHistory: (store: string) => axios.get("/api/history", {
    params: {
      store: store,
    },
  }),
  getElasticity: (products: Array<String>, profitVolumeToggle: String): Promise<ApiResponse<ElasticityData>> => axios.post("/api/elasticity", {
    products: products,
    profitVolumeToggle: profitVolumeToggle,
  }),
  getCategories: (): Promise<any> => axios.get("/api/categories", {
  }),
  getProducts: (): Promise<any> => axios.get("/api/products", {
  }),
  getCategoriesAggregated: (): Promise<any> => axios.get("/api/categories_aggregated", {
  }),
  getParameters: (): Promise<any> => axios.get("/api/load_frontend_parameters", {
  }),
  buildAllUpdate: (rows: any[]): Promise<any> => axios.post("/api/build_all_update", {
    rows: rows,
  }),
  // getResults: (products: string[]): Promise<any> => axios.post("/bs_api/dataset/get_filtered_dataset", {
  //   "dataset_name": "display_table_by_product_id_prepared",
  //   "chunksize": 100,
  //   "chunk_index": 0,
  //   "filters": {
  //     "product_id": products
  //   }
  // }),
  getResults: (): Promise<any> => axios.get("/api/optimization_results"),
  getScenarioStatus: (scenario_name: string, scenario_id: string): Promise<any> => axios.get("/api/scenario_status", {
    params: {
      scenario_name: scenario_name,
      scenario_id: scenario_id
    },
  }),
  getWikiArticle: (article_id: string): Promise<any> => axios.get("/api/wiki", {
    params: {
      article_id: article_id,
    },
  }),

  getProjectVariable: (variable_name: string, project: string): Promise<any> => axios.get("/api/project_variable", {
    params: {
      variable_name: variable_name,
      project: project
    },
  }),
  getDemandForecastTimeScale: (): Promise<any> => axios.get("/api/demand_forecast_time_scale", {
  }),
    
  getLastRun: (): Promise<any> => axios.get("/api/last_run", {
  }),
};