# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# -*- coding: utf-8 -*-
import dataiku
import pandas as pd, numpy as np
from dataiku import pandasutils as pdu
from dku_utils.projects.recipes.recipe_commons import adapt_recipe_engine_to_priority_and_availability, update_recipe_ouput_schema
from dku_utils.projects.project_commons import get_current_project_and_variables, get_project_and_variables

# Read recipe inputs
min_max_discount = dataiku.Dataset("min_max_discount")
min_max_discount_df = min_max_discount.get_dataframe()

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
min_discount = min_max_discount_df["min_markdown_min"].loc[0]
max_discount = min_max_discount_df["max_markdown_max"].loc[0]
project, variables = get_current_project_and_variables()
step = variables["standard"]["discount_step_app"]


# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
possible_markdown = np.linspace(min_discount,max_discount,num=step,endpoint=True)
                                
# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
available_discount_df = pd.DataFrame(possible_markdown,columns=["possible_discount"])


# Write recipe outputs
available_discount = dataiku.Dataset("available_discount")
available_discount.write_with_schema(available_discount_df)