# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# -*- coding: utf-8 -*-
import dataiku
import pandas as pd, numpy as np
from dataiku import pandasutils as pdu

# Read recipe inputs
historic_data = dataiku.Dataset("historic_data_prepared")
historic_data_df = historic_data.get_dataframe()


# Compute recipe outputs from inputs
historic_data_melted_df = pd.melt(frame=historic_data_df, id_vars=["date","forecast_granularity"])


if len(historic_data_melted_df["forecast_granularity"].unique())>1:
    historic_data_melted_df = historic_data_melted_df[historic_data_melted_df["forecast_granularity"]!="all_stores"]
    
# Write recipe outputs
historic_data_melted = dataiku.Dataset("historic_data_melted")
historic_data_melted.write_with_schema(historic_data_melted_df)