import numpy as np
import pandas as pd

def compute_all_hierarchy_dependencies(hierarchy_dataframe, columns_hierarchy, forecast_focus_column):
    hierarchy_dependencies = {}
    n_columns_in_hierarchy = len(columns_hierarchy)
    column_analyzed = []
    
    for loop_index, column in enumerate(columns_hierarchy):
        column_analyzed.append(column)
        column_is_first_in_hierarchy = (loop_index == 0)
        column_is_not_last_in_hierarchy = (loop_index != n_columns_in_hierarchy - 1)
        hierarchy_dependencies[column] = {}
        
        if column_is_first_in_hierarchy:
            column_has_parent = False
            column_first_parent = None
        else:
            column_has_parent= True
            column_first_parent = columns_hierarchy[loop_index - 1]
        
        if column_is_not_last_in_hierarchy:
            next_column_in_hierarchy = columns_hierarchy[loop_index + 1]
            hierarchy_dependencies[column]["has_child"] = True
            hierarchy_dependencies[column]["first_child"] = next_column_in_hierarchy
            hierarchy_dependencies[column]["all_children"] = [column for column in columns_hierarchy if not column in column_analyzed]
            
            
        else:
            next_column_in_hierarchy = None
            hierarchy_dependencies[column]["has_child"] = False
            hierarchy_dependencies[column]["first_child"] = None
            hierarchy_dependencies[column]["all_children"] = []
        
        hierarchy_dependencies[column]["has_parent"] = column_has_parent
        hierarchy_dependencies[column]["first_parent"] = column_first_parent
            
        hierarchy_dependencies[column]["child_constraints"] = {}            
        column_possible_values = list(np.unique(hierarchy_dataframe[column]))
        hierarchy_dependencies[column]["possible_values"] = column_possible_values

        for possible_value in column_possible_values:
            filtered_hierarchy_dataframe = hierarchy_dataframe[hierarchy_dataframe[column]==possible_value].copy()
            if column_is_not_last_in_hierarchy:
                column_child_constraints =list(np.unique(filtered_hierarchy_dataframe[next_column_in_hierarchy]))
            else:
                column_child_constraints = []
            hierarchy_dependencies[column]["child_constraints"][possible_value] = column_child_constraints
                
            forecast_focus_associated_values = list(filtered_hierarchy_dataframe[forecast_focus_column])
            hierarchy_dependencies[column]["forecast_focus_associated_values"] = forecast_focus_associated_values
            pass
    return hierarchy_dependencies