import dataiku

from dku_utils.projects.project_commons import get_current_project_and_variables
from dku_utils.projects.recipes.join_recipe import (
    programmaticJoinHandler,
    compute_join_recipe_computed_column_settings,
)
from dku_utils.projects.recipes.recipe_commons import (
    adapt_recipe_engine_to_priority_and_availability,
    update_recipe_ouput_schema,
)

project, variables = get_current_project_and_variables()
recipe_name = "compute_sales_x_features_joined"


rfm_dataset = dataiku.Dataset("demand_forecast_features_filtered")

schema = rfm_dataset.read_schema()
main_columns = list(
    filter(
        lambda name: name
        not in [
            "reference_period_product_base_price",
            "forecast_period_product_average_discount",
            "periods_discount_delta",
        ],
        map(lambda pair: pair["name"], schema),
    )
)


product_strategy_columns = [
    "product_cost",
    "product_base_price",
    "min_markdown",
    "max_markdown",
    "profit_parameter",
    "volume_parameter",
    "override_flag",
    "optimization_strategy",
    "override_value",
]
product_strategy_alias = {"product_base_price": "reference_period_product_base_price"}
optional_datasets = variables["standard"]["optional_datasets_app"]

inventory_columns = ["stock"]

if "product_inventory" not in optional_datasets:
    main_columns.append("stock")
    join_handler = programmaticJoinHandler(
        project=project,
        recipe_name=recipe_name,
        main_dataset_name="demand_forecast_features_filtered",
        main_dataset_columns_to_select=main_columns,
        main_dataset_columns_to_select_alias={},
        main_dataset_computed_columns=[compute_join_recipe_computed_column_settings(
            "stock", "bigint", "-1"
        )]
    )
else:
    join_handler = programmaticJoinHandler(
        project=project,
        recipe_name=recipe_name,
        main_dataset_name="demand_forecast_features_filtered",
        main_dataset_columns_to_select=main_columns,
        main_dataset_columns_to_select_alias={},
        main_dataset_computed_columns=None,
    )


join_handler.add_one_join_on_main_dataset(
    dataset_to_join_name="product_strategy_synced",
    dataset_to_join_columns_to_select=product_strategy_columns,
    join_type="INNER",
    columns_prefix=None,
    left_join_key=["product_id"],
    right_join_key=["product_id"],
    columns_to_select_alias=product_strategy_alias,
    dataset_computed_columns=None,
)


if "product_inventory" in optional_datasets:
    join_handler.add_one_join_on_main_dataset(
        dataset_to_join_name="product_inventory",
        dataset_to_join_columns_to_select=inventory_columns,
        join_type="LEFT",
        columns_prefix=None,
        left_join_key=["product_id", "forecast_granularity"],
        right_join_key=["product_id", "forecast_granularity"],
        columns_to_select_alias={},
        dataset_computed_columns=None,
    )


adapt_recipe_engine_to_priority_and_availability(project, recipe_name)
update_recipe_ouput_schema(project, recipe_name)
