from dku_utils.projects.project_commons import get_current_project_and_variables
from dku_utils.projects.recipes.join_recipe import programmaticJoinHandler
from dku_utils.projects.recipes.recipe_commons import (
    adapt_recipe_engine_to_priority_and_availability,
    update_recipe_ouput_schema,
)
from markdown_optimization.constants import CONFIGURATION_DATA_SCHEMA


def join_product_configuration():
    project, variables = get_current_project_and_variables()
    recipe_name = "compute_product_configuration"

    optional_datasets = variables["standard"]["optional_datasets_app"]

    selected_datasets = set(optional_datasets).intersection(
        CONFIGURATION_DATA_SCHEMA.keys()
    )
    missing_datasets = set(CONFIGURATION_DATA_SCHEMA.keys()).difference(
        optional_datasets
    )
    columns_to_add = ["product_id"]
    computed_columns = []
    for dataset in missing_datasets:
        computed_columns += CONFIGURATION_DATA_SCHEMA[dataset]["computed"]
        columns_to_add += CONFIGURATION_DATA_SCHEMA[dataset]["columns"]

    join_handler = programmaticJoinHandler(
        project=project,
        recipe_name=recipe_name,
        main_dataset_name="sales_x_features_joined_by_product_id",
        main_dataset_columns_to_select=columns_to_add,
        main_dataset_columns_to_select_alias={},
        main_dataset_computed_columns=computed_columns,
    )

    if len(selected_datasets) > 0:
        for dataset in selected_datasets:
            join_handler.add_one_join_on_main_dataset(
                dataset_to_join_name=dataset,
                dataset_to_join_columns_to_select=CONFIGURATION_DATA_SCHEMA[dataset][
                    "columns"
                ],
                join_type="LEFT",
                columns_prefix=None,
                left_join_key=["product_id"],
                right_join_key=["product_id"],
                columns_to_select_alias={},
                dataset_computed_columns=None,
            )
    else:
        # fake join with itself if no product configuration
        join_handler.add_one_join_on_main_dataset(
            dataset_to_join_name="sales_x_features_joined_by_product_id",
            dataset_to_join_columns_to_select=[],
            join_type="LEFT",
            columns_prefix=None,
            left_join_key=["product_id"],
            right_join_key=["product_id"],
            columns_to_select_alias={},
            dataset_computed_columns=None,
        )

    adapt_recipe_engine_to_priority_and_availability(project, recipe_name)
    update_recipe_ouput_schema(project, recipe_name)

    output_dataset = "product_configuration"
    join_output_dataset = project.get_dataset(output_dataset)
    join_output_dataset.build()
