import dataiku

from dku_utils.projects.project_commons import get_current_project_and_variables
from dku_utils.projects.folders.folder_commons import get_managed_folder_id
from dku_utils.projects.recipes.join_recipe import programmaticJoinHandler
from dku_utils.projects.recipes.recipe_commons import (
    adapt_recipe_engine_to_priority_and_availability,
    update_recipe_ouput_schema,
    get_recipe_settings_and_dictionary,
    switch_visual_recipe_input,
)


def join_strategy_webapp():
    project, variables = get_current_project_and_variables()

    webapp_folder = project.get_managed_folder(
        get_managed_folder_id(project, "webapp_writeback")
    )
    if len(webapp_folder.list_contents()["items"]) > 0:
        recipe_name = "compute_product_strategy_with_webapp"
        strategy_dataset = dataiku.Dataset("product_strategy_merged")

        schema = strategy_dataset.read_schema()
        main_columns = list(map(lambda pair: pair["name"], schema),)

        webapp_product_strategy_columns = [
            "product_cost",
            "reference_period_product_base_price",
            "min_markdown",
            "max_markdown",
            "profit_parameter",
            "volume_parameter",
            #"override_flag",
            "optimization_strategy",
            #"override_value",
        ]
        webapp_strategy_alias = {
            "product_cost": "webapp_product_cost",
            "reference_period_product_base_price": "webapp_product_base_price",
            "min_markdown": "webapp_min_markdown",
            "max_markdown": "webapp_max_markdown",
            "profit_parameter": "webapp_profit_parameter",
            "volume_parameter": "webapp_volume_parameter",
            #"override_flag": "webapp_override_flag",
            "optimization_strategy": "webapp_optimization_strategy",
            #"override_value": "webapp_override_value",
        }

        join_handler = programmaticJoinHandler(
            project=project,
            recipe_name=recipe_name,
            main_dataset_name="product_strategy_merged",
            main_dataset_columns_to_select=main_columns,
            main_dataset_columns_to_select_alias={},
            main_dataset_computed_columns=None,
        )

        join_handler.add_one_join_on_main_dataset(
            dataset_to_join_name="writeback_webapp_synced_windows_prepared",
            dataset_to_join_columns_to_select=webapp_product_strategy_columns,
            join_type="LEFT",
            columns_prefix=None,
            left_join_key=["product_id"],
            right_join_key=["product_id"],
            columns_to_select_alias=webapp_strategy_alias,
            dataset_computed_columns=None,
        )

        adapt_recipe_engine_to_priority_and_availability(project, recipe_name)
        update_recipe_ouput_schema(project, recipe_name)

        output_dataset = "product_strategy_with_webapp"
        join_output_dataset = project.get_dataset(output_dataset)
        join_output_dataset.build()

        prepare_dataset_name = "product_strategy_with_webapp_prepared"
        prepared_recipe = "compute_product_strategy_with_webapp_prepared"
        adapt_recipe_engine_to_priority_and_availability(project, prepared_recipe)
        update_recipe_ouput_schema(project, prepared_recipe)
        prepare_dataset = project.get_dataset(prepare_dataset_name)
        prepare_dataset.build()

    else:
        prepare_dataset_name = "product_strategy_merged"

    synced_name = "compute_product_strategy_synced"
    recipe_settings, dict_set = get_recipe_settings_and_dictionary(
        project, synced_name, True
    )
    switch_visual_recipe_input(
        project,
        recipe_name=synced_name,
        current_input_dataset_name=dict_set["inputs"]["main"]["items"][0]["ref"],
        new_input_dataset_name=prepare_dataset_name,
    )
    update_recipe_ouput_schema(project, synced_name)
