from dku_utils.projects.project_commons import get_current_project_and_variables
from dku_utils.projects.recipes.join_recipe import programmaticJoinHandler
from dku_utils.projects.recipes.recipe_commons import (
    adapt_recipe_engine_to_priority_and_availability,
    update_recipe_ouput_schema,
)


def join_transaction_filtered():
    project, variables = get_current_project_and_variables()
    recipe_name = "compute_transactions_filtered"

    optional_datasets = variables["standard"]["optional_datasets_app"]

    product_strategy_columns = [
        "product_cost",
        "min_markdown",
        "max_markdown",
        "profit_parameter",
        "volume_parameter",
        "product_base_price",
        "override_flag",
        "optimization_strategy",
        "override_value",
    ]
    join_handler = programmaticJoinHandler(
        project=project,
        recipe_name=recipe_name,
        main_dataset_name="transactions_by_article_id",
        main_dataset_columns_to_select=[
            "product_id",
            "reference_period_product_base_price_max",
        ],
        main_dataset_columns_to_select_alias={
            "reference_period_product_base_price_max": "product_price_max"
        },
        main_dataset_computed_columns=[],
    )

    join_handler.add_one_join_on_main_dataset(
        dataset_to_join_name="product_configuration",
        dataset_to_join_columns_to_select=product_strategy_columns,
        join_type="LEFT",
        columns_prefix=None,
        left_join_key=["product_id"],
        right_join_key=["product_id"],
        columns_to_select_alias={},
        dataset_computed_columns=None,
    )
    if "product_to_markdown" in optional_datasets:
        join_handler.add_one_join_on_main_dataset(
            dataset_to_join_name="product_to_markdown",
            dataset_to_join_columns_to_select=[],
            join_type="RIGHT",
            columns_prefix=None,
            left_join_key=["product_id"],
            right_join_key=["product_id"],
            columns_to_select_alias={},
            dataset_computed_columns=None,
        )
    adapt_recipe_engine_to_priority_and_availability(project, recipe_name)
    update_recipe_ouput_schema(project, recipe_name)

    output_dataset = "transactions_filtered"
    join_output_dataset = project.get_dataset(output_dataset)
    join_output_dataset.build()
