from dku_utils.projects.project_commons import get_current_project_and_variables, get_project_and_variables
from dku_utils.projects.recipes.recipe_commons import (
    get_recipe_settings_and_dictionary,
    adapt_recipe_engine_to_priority_and_availability,
    update_recipe_ouput_schema,
)


def prepare_display():
    project, variables = get_current_project_and_variables()

    recipe_name = "compute_test_dataset"
    recipe_settings, _ = get_recipe_settings_and_dictionary(project, recipe_name, False)
    recipe_json_payload = recipe_settings.get_json_payload()

    project_demand, variables_demand = get_project_and_variables(
        variables["standard"]["demand_forecast_project_key_app"]
    )
    keep_columns = [
          "profit_parameter",
          "base_price",
          "sell_price",
          "volume_parameter",
          "revenue",
          "profit_uplift_static",
          "product_cost",
          "forecasted_volume",
          "profit_per_unit",
          "profit_uplift_zero",
          "stock",
          "margin",
          "volume_uplift_zero",
          "optimization_strategy",
          "global_strategy",
          "volume_uplift_static",
          "total_profit",
          "lost_sales",
          "max_markdown",
          "product_id",
          "min_markdown",
          "lost_profit",
          "sellthrought_rate",
          "discount_pct",
        ]
    
    round_columns= [
          "base_price",
          "sell_price",
          "revenue",
          "profit_uplift_static",
          "product_cost",
          "forecasted_volume",
          "profit_per_unit",
          "profit_uplift_zero",
          "stock",
          "margin",
          "volume_uplift_zero",
          "volume_uplift_static",
          "total_profit",
          "lost_sales",
          "max_markdown",
          "min_markdown",
          "lost_profit",
          "sellthrought_rate",        
    ]
    recipe_json_payload["steps"][1]["params"]["columns"] = keep_columns+variables_demand[
        "standard"
    ]["timeseries_identifiers_columns"][0:-1]

    recipe_json_payload["steps"][2]["params"]["columns"] = round_columns
    
    
    recipe_settings.set_json_payload(recipe_json_payload)
    recipe_settings.save()

    adapt_recipe_engine_to_priority_and_availability(project, recipe_name)
    update_recipe_ouput_schema(project, recipe_name)

    


