import dataiku

from dku_utils.projects.connections.connection_commons import FlowConnectionsHandler
from dku_utils.projects.project_commons import get_current_project_and_variables
from dku_utils.projects.datasets.dataset_commons import get_dataset_in_connection_settings
from markdown_optimization.constants import (
    FALLBACK_CONNECTIONS,
    FALLBACK_DATASETS,
)


def change_connection():
    project, variables = get_current_project_and_variables()

    main_connection_name = variables["standard"]["main_connection_name_app"]

    main_connection_settings = get_dataset_in_connection_settings(
        project, main_connection_name
    )
    main_connection_type = main_connection_settings["type"]
    managed_dataset_format = variables["standard"]["managed_dataset_format_app"]
    df_dataset = dataiku.Dataset(
        "input_demand_data_w_pricing",
        project_key=variables["standard"]["demand_forecast_project_key_app"],
    )
    if main_connection_type == "Filesystem":
        datasets_to_tables_or_paths_mapping = {
            "demand_forecast_data": df_dataset.get_config()["params"]["path"].replace("${projectKey}",variables["standard"]["demand_forecast_project_key_app"])
        }
    else:
        datasets_to_tables_or_paths_mapping = {
            "demand_forecast_data": df_dataset.get_config()["params"]["table"].replace("${projectKey}",variables["standard"]["demand_forecast_project_key_app"])
        }

    #if main_connection_type in ["Redshift", "Synapse", "BigQuery"]:
    #   fallback_connection_name = variables["standard"]["fallback_connection_name_app"]
    #    fallback_connection_datasets_downstream_recipes = FALLBACK_CONNECTIONS
    #    fallback_connection_datasets = FALLBACK_DATASETS
    #else:
    #    fallback_connection_name = None
    #    fallback_connection_datasets_downstream_recipes = None
    #    fallback_connection_datasets = None

    folder_connection_name = variables["standard"]["folder_connection_name_app"]

    flow_connection_handler = FlowConnectionsHandler(
        project=project,
        main_connection_name=main_connection_name,
        fallback_connection_name=None,
        input_datasets=["demand_forecast_data"],
        input_datasets_to_preserve=["writeback_webapp"],
        fallback_connection_datasets=[],
        fallback_connection_datasets_downstream_recipes=[],
        input_folders=["webapp_writeback"],
        bool_change_computed_folders_connections=True,
        folders_connection_name=folder_connection_name,
        project_folders_to_preserve=[],
    )
    flow_connection_handler.switch_flow_datasets_connections(
        managed_datasets_write_file_format=managed_dataset_format
    )
    flow_connection_handler.switch_input_datasets_to_not_managed_sate()
    flow_connection_handler.switch_flow_folders_connections()

    flow_connection_handler.connect_flow_input_datasets(
        datasets_to_tables_or_paths_mapping
    )

    if main_connection_type in ["Redshift", "Synapse", "BigQuery"]:
        pass
        #flow_connection_handler.adapt_flow_to_fast_path()

    variables["standard"]["not_connected_flag"] = False
    if "not_connected_flag" in variables["local"]:
        variables["local"]["not_connected_flag"] = False

    project.set_variables(variables)
