import dataiku

from dku_utils.projects.project_commons import get_current_project_and_variables, get_project_and_variables
from dku_utils.projects.security.sharing import share_object_with_id
from dku_utils.projects.recipes.python_recipe import set_python_recipe_inputs


def import_demand_forecast_data():
    project, variables = get_current_project_and_variables()
    flow = project.get_flow()

    demand_forecast_key = variables["standard"]["demand_forecast_project_key_app"]
    demand_forecast_project, demand_forecast_variables = get_project_and_variables(
        demand_forecast_key
    )

    demand_forecast_input_zone = list(
        filter(lambda zone: zone.name == "Mandatory Inputs", flow.list_zones())
    )[0]
    
    inference_zone = list(
        filter(lambda zone: zone.name == "Inference", flow.list_zones())
    )[0]

    base_inputs = []

    demand_model = dataiku.Model(
        "Demand forecast", project_key=demand_forecast_key
    )
    share_object_with_id(
        object_id=demand_model.get_id(),
        object_type="SAVED_MODEL",
        project=demand_forecast_project,
        target_project_key=project.project_key,
        enable_quick_sharing=False,
    )
     
    demand_model = demand_forecast_project.get_saved_model(demand_model.get_id())
    demand_forecast_input_zone.add_item(demand_model)
    inference_zone.add_shared(demand_model)
    
    variables["standard"]["demand_forecast_model"] = f"{demand_forecast_key}.{demand_model.id}"
    project.set_variables(variables)

    
"""    base_inputs.append(f"{demand_forecast_key}.{demand_model.id}")
    
    N_inference=5
    
    for i in range(N_inference):
        set_python_recipe_inputs(
            project,
            f"score_inference_{i}",
            base_inputs + [f"inference_{i}"],
        )

    set_python_recipe_inputs(
        project,
        "score_stack_current_1",
        base_inputs + ["stack_current"],
    )"""
