interface HierarchyDependency {
    child_constraints: Record<string, string[]>;
    possible_values: string[];
}

export enum TimeGranularity {
    weeks = "weeks",
    days = "days",
    months = "months",
}

export interface HierarchyData {
    hierarchy_dependencies: Record<string, HierarchyDependency>;
    product_hierarchy: string[];
}


export interface FrontendParameters {
    all_granularities: string[];
    granularity_x_hierarchy_constraints: Record<string,Record<string, string[]>>;
    hierarchy_data: HierarchyData;
    time_granularity: TimeGranularity;
    date_constraints: {
        current_date: string;
        dates: string[];
        max_date: string;
        min_date: string;
    };
    leverage_inventory: boolean
}

interface SalesData {
    dates: string[];
    sales: number[];
};

export interface TimeSeriesData {
    forecast_time_series_data: {
        dates: string[];
        demand_forecast: number[];
    };

    past_sales_data: SalesData;
    current_sales_data: SalesData;

    historical_period_max_date: string;
    historical_period_min_date: string;

    y_axis_parameters: {
        y_axis_max: number;
        y_axis_min: number;
    };
    stock_data: SalesData;
};