# Optional Datasets

![optional.png](vZyZbaQcPVVu)

## Product Markdown constraints

|Name | Description | Type | Example | Mandatory |
|---|---|---|---|---|
| product_id  |unique identifier for a product | string  | "5846"  |  yes |
| min_markdown  | minimum discount ratio for this product | double  | -20  |  yes |
| max_markdown  | maximum discount ratio for this product | double  | 80 |  yes |

minimum and maximum markdown should be between -100 and 100. A negative markdown represent a possible price increase.

The solution will only explore discounts between min_markdown and max_markdown. max_markdown should be stricly supperior to min_markdown, if you want to fix a discount use override_value in the product_override dataset.

## Product Strategy

|Name | Description | Type | Example | Mandatory |
|---|---|---|---|---|
| product_id  |unique identifier for a product | string  | "5846"  |  yes |
| optimization_strategy  |unique identifier for a given transaction | string  | "profit"  |  yes |

optimization_strategy specifies what metric is chosen for the optimization:
 - "profit" then the markdown selected will seek the best profit
 - "volume" it will maximize the volume of sales
 - "custom" it will maximize a weighted average of the profit and volume change (see product_balance_parameters)

## Product Balance Parameters

|Name | Description | Type | Example | Mandatory |
|---|---|---|---|---|
| product_id  |unique identifier for a product | string  | "5846"  |  yes |
| profit_parameter  | weight for the profit uplift | double  | 0.8  |  yes |
| volume_parameter | weight for the volume uplift | double  | 0.3  |  yes |

The parameters are used in the "custom" optimization strategy:

  (profit_parameter * profit_uplift + volume_parameter*volume_uplift)/(profit_parameter+volume_parameter)

## Product Cost

|Name | Description | Type | Example | Mandatory |
|---|---|---|---|---|
| product_id  |unique identifier for a product | string  | "5846"  |  yes |
| product_cost  | cost of the product for the forecasting period | double  | 8  |  yes |
| product_base_price  | public full price of the product for the forecasting period | double  | 12.5  |  yes |

The base price is the reference public price of a product. The product_cost is defined as the cost incured to create, transport and sell a given product. The difference between the sell price and the product_cost is the profit margin of a given product. 


## Product Override

|Name | Description | Type | Example | Mandatory |
|---|---|---|---|---|
| product_id  |unique identifier for a product | string  | "5846"  |  yes |
| override_flag  | indicates if the override value should be used or not | boolean  | true  |  yes |
| override_value  | fixed markdown value that will ignore the optimization process | double  | 0.8  |  yes |

When you don't want a product to go through the optimization process, put the override_flag to true and the override_value will be used instead. If override_flag is false, the value is ignored.

## Product Inventory

|Name | Description | Type | Example | Mandatory |
|---|---|---|---|---|
| product_id  |unique identifier for a product | string  | "5846"  |  yes |
| stock  | number of units available for sale during the forecasting period | integer  | 512  |  yes |
| forecast_granularity  | specific store where the inventory is located."all_data" by default| string  | "store_1" |  yes |

forecast_granularity should match the one defined in the demand forecast if used

## Product to markdown

|Name | Description | Type | Example | Mandatory |
|---|---|---|---|---|
| product_id  |unique identifier for a product | string  | "5846"  |  yes |

List of products to include in markdown optimization; if not used, all product will be optimized.