FLOW_INPUT_DATASETS = ["transactions_dataset"]
FLOW_INPUT_DATASETS_TO_PRESERVE = []
FLOW_INPUT_FOLDERS = []

# 'FALLBACK_CONNECTION_DATASETS' are datasets that are python processes outputs and that needs to be written in a cloud provicer cloud storage. 
# Some of them will then need to be synchronized in the main SQL connection, leveraging 'FALLBACK_CONNECTION_DATASETS_DOWNSTREAM_RECIPES': 
FALLBACK_CONNECTION_DATASETS = ["distinct_itemsets", "rules_denormalized_antecedents", "rules_denormalized_consequents",
                                "association_rules", "association_rules_summary", "up_sales_recommendations",
                                "cross_sales_recommendations"]

FALLBACK_CONNECTION_DATASETS_DOWNSTREAM_RECIPES = {
    "rules_denormalized_antecedents": ["compute_valid_rules_denormalized_antecedents"],
    "rules_denormalized_consequents": ["compute_valid_rules_denormalized_consequents"],
    "association_rules": ["compute_valid_association_rules"],
    "up_sales_recommendations": ["compute_up_sales_best_recommendations"],
    "cross_sales_recommendations": ["compute_cross_sales_best_recommendations"]
}

DISTINCT_ITEMSETS_COLUMNS = ["itemset", "itemset_size", "itemset_support", "total_itemsets"]

ITEMSETS_SORT_COLUMNS = ["itemset_support", "itemset_size"]

ASSOCIATION_RULES_COLUMNS_RENAMINGS = {"antecedent":"rule_antecedent", "consequent":"rule_consequent",
                                       "antecedent support":"rule_antecedent_support", "consequent support":"rule_consequent_support",
                                       "confidence":"rule_confidence", "lift":"rule_lift", "conviction":"rule_conviction",
                                       "antecedent_size":"rule_antecedent_size", "consequent_size":"rule_consequent_size"}

ASSOCIATION_RULES_COLUMNS = ["rule_antecedent", "rule_consequent", "rule_support", "support_interpretation",
                            "rule_antecedent_support", "rule_consequent_support", "rule_confidence",
                            "confidence_interpretation", "rule_lift", "lift_interpretation",
                            "rule_conviction", "conviction_interpretation",
                            "rule_antecedent_size", "rule_consequent_size"]

ASSOCIATION_RULES_COLUMNS_DATATYPES = {
    "rule_antecedent": "string",
    "rule_consequent": "string",
    "rule_support": "double",
    "support_interpretation": "string",
    "rule_antecedent_support": "double",
    "rule_consequent_support": "double",
    "rule_confidence": "double",
    "confidence_interpretation": "string",
    "rule_lift": "double",
    "lift_interpretation": "string",
    "rule_conviction": "double",
    "conviction_interpretation": "string",
    "rule_antecedent_size": "bigint",
    "rule_consequent_size": "bigint"
}

DISTINCT_ITEMSETS_COLUMNS_DATATYPES = {
    "itemset": "string",
    "itemset_size": "bigint",
    "itemset_support":  "double",
    "total_itemsets": "bigint"
}

ASSOCIATION_RULES_RECIPE_OUTPUT_DATASETS = ["association_rules", 
                                            "distinct_itemsets",
                                            "rules_denormalized_antecedents",
                                            "rules_denormalized_consequents",
                                            "association_rules_summary"]

ASSOCIATION_RULES_SORT_COLUMNS = ["rule_confidence", "rule_lift", "rule_conviction", "rule_support"]

RULES_METRICS_COLUMNS = ["rule_antecedent_support", "rule_consequent_support",
                         "rule_confidence", "rule_support", "rule_lift", "rule_conviction"]

ITEMS_RECOMMENDATION_COLUMNS = ['customer_id', 'rule_id', 'rule_antecedent', 'rule_consequent',
                                'item_recommendation', 'rule_support', 'rule_confidence', 'rule_lift',
                                'rule_conviction']

DEFAULT_METRICS_PRIORITY = ["rule_confidence", "rule_lift", "rule_conviction", "rule_support"]

DEFAULT_INFINITE_VALUE = 9999

FLOW_REFRESH_SCENARIO_ID = "REFRESH_FLOW_OVER_TIME"