CANDIDATE_CONSEQUENTS_REFERENCE_DATASET_FOR_SCHEMA = "customers_last_transactions_unique_items_prepared"
CANDIDATE_CONSEQUENTS_DEFAULT_JOIN_KEYS = [
    {'column1': {'name': 'customer_id', 'table': 0},
     'column2': {'name': 'customer_id', 'table': 1},
     'type': 'EQ'
    },
    {'column1': {'name': 'item', 'table': 0},
     'column2': {'name': 'consequent_item', 'table': 1},
     'type': 'EQ'}
]

CANDIDATE_CONSEQUENTS_DEFAULT_JOIN_SELECTED_COLUMNS = [
    {'name': 'customer_id', 'table': 0, 'type': 'string'},
    {'name': 'item', 'table': 0, 'type': 'string'},
    {'name': 'consequent_item', 'table': 1, 'type': 'string', 'alias': 'candidate_consequent_item'},
    {'name': 'customer_id', 'table': 1, 'type': 'string', 'alias': 'consequent_potential_customer_id'}
]

CANDIDATE_RULES_DEFAULT_JOIN_KEYS = [{'column1': {'name': 'candidate_consequent_item', 'table': 0},
                                      'column2': {'name': 'consequent_item', 'table': 1},
                                      'type': 'EQ'}]

CANDIDATE_RULES_DEFAULT_JOIN_SELECTED_COLUMNS = [{'name': 'customer_id', 'table': 0, 'type': 'string'},
                                                 {'name': 'candidate_consequent_item', 'table': 0, 'type': 'string'},
                                                 {'name': 'rule_id', 'table': 1, 'type': 'string'},
                                                 {'name': 'rule_support', 'table': 1, 'type': 'double'},
                                                 {'name': 'rule_confidence', 'table': 1, 'type': 'double'},
                                                 {'name': 'rule_lift', 'table': 1, 'type': 'double'},
                                                 {'name': 'rule_conviction', 'table': 1, 'type': 'double'},
                                                 {'name': 'rule_antecedent', 'table': 1, 'type': 'string'},
                                                 {'name': 'rule_antecedent_size', 'table': 1, 'type': 'bigint'},
                                                 {'name': 'rule_consequent', 'table': 1, 'type': 'string'},
                                                 {'name': 'rule_consequent_size', 'table': 1, 'type': 'bigint'}]


REQUIRED_ANTECEDENTS_DEFAULT_JOIN_KEYS = [{'column1': {'name': 'candidate_rule_id', 'table': 0},
                                           'column2': {'name': 'rule_id', 'table': 1},
                                           'type': 'EQ'}]

REQUIRED_ANTECEDENTS_DEFAULT_JOIN_SELECTED_COLUMNS = [{'name': 'customer_id', 'table': 0, 'type': 'string'},
                                                      {'name': 'candidate_consequent_item', 'table': 0, 'type': 'string'},
                                                      {'name': 'candidate_rule_id', 'table': 0, 'type': 'string'},
                                                      {'name': 'candidate_rule_support', 'table': 0, 'type': 'double'},
                                                      {'name': 'candidate_rule_confidence', 'table': 0, 'type': 'double'},
                                                      {'name': 'candidate_rule_lift', 'table': 0, 'type': 'double'},
                                                      {'name': 'candidate_rule_conviction', 'table': 0, 'type': 'double'},
                                                      {'name': 'candidate_rule_antecedent', 'table': 0, 'type': 'string'},
                                                      {'name': 'candidate_rule_antecedent_size', 'table': 0, 'type': 'bigint'},
                                                      {'name': 'candidate_rule_consequent', 'table': 0, 'type': 'string'},
                                                      {'name': 'candidate_rule_consequent_size', 'table': 0, 'type': 'bigint'},
                                                      {'name': 'antecedent_item', 'table': 1, 'type': 'string'}
                                                     ]

PURCHASED_ANTECEDENTS_DEFAULT_JOIN_KEYS = [{'column1': {'name': 'customer_id', 'table': 0},
                                           'column2': {'name': 'customer_id', 'table': 1},
                                           'type': 'EQ'},
                                           {'column1': {'name': 'required_antecedent_item', 'table': 0},
                                           'column2': {'name': 'item', 'table': 1},
                                           'type': 'EQ'}
                                          ]

PURCHASED_ANTECEDENTS_DEFAULT_JOIN_SELECTED_COLUMNS = [{'name': 'customer_id', 'table': 0, 'type': 'string'},
                                                      {'name': 'candidate_consequent_item', 'table': 0, 'type': 'string'},
                                                      {'name': 'candidate_rule_id', 'table': 0, 'type': 'string'},
                                                      {'name': 'candidate_rule_support', 'table': 0, 'type': 'double'},
                                                      {'name': 'candidate_rule_confidence', 'table': 0, 'type': 'double'},
                                                      {'name': 'candidate_rule_lift', 'table': 0, 'type': 'double'},
                                                      {'name': 'candidate_rule_conviction', 'table': 0, 'type': 'double'},
                                                      {'name': 'candidate_rule_antecedent', 'table': 0, 'type': 'string'},
                                                      {'name': 'candidate_rule_antecedent_size', 'table': 0, 'type': 'bigint'},
                                                      {'name': 'candidate_rule_consequent', 'table': 0, 'type': 'string'},
                                                      {'name': 'candidate_rule_consequent_size', 'table': 0, 'type': 'bigint'},
                                                      {'name': 'required_antecedent_item', 'table': 0, 'type': 'string'},
                                                      {'name': 'required_antecedent_state', 'table': 1, 'type': 'string'}
                                                     ]
RULES_SUMMARY_DEFAULT_IDENTIFIERS = ['customer_id',
                                     'candidate_rule_id',
                                     'candidate_rule_antecedent',
                                     'candidate_rule_consequent',
                                     'candidate_rule_support',
                                     'candidate_rule_confidence',
                                     'candidate_rule_lift',
                                     'candidate_rule_conviction',
                                     'candidate_rule_antecedent_size'
                                    ]

BEST_ACTIONABLE_RULES_DEFAULT_PARTITIONING_COLUMNS = ["customer_id", "rule_consequent"]
BEST_ACTIONABLE_RULES_DEFAULT_COLUMNS_TO_RETRIEVE = [
    "customer_id",
    "rule_id",
    "rule_antecedent",
    "rule_consequent",
    "rule_support",
    "rule_confidence",
    "rule_lift",
    "rule_conviction",
    "rule_antecedent_size",
    "n_matching_antecedents",
    "actionable_rule",
    "rule_for_consequent_rank"
]
BEST_RECOMMENDATIONS_DEFAULT_PARTITIONING_COLUMNS = ["customer_id", "item_recommendation"]
BEST_RECOMMENDATIONS_DEFAULT_COLUMNS_TO_RETRIEVE = [
    "customer_id",
    "rule_id",
    "rule_antecedent",
    "rule_consequent",
    "item_recommendation",
    "rule_support",
    "rule_confidence",
    "rule_lift",
    "rule_conviction",
    "rule_for_item_rank",
    "n_rules_leading_to_item"
]

RECIPES_PARAMS = {
    # transactions_preprocessing
    "compute_transactions_prepared":{
        "name":"compute_transactions_prepared",
        "flow_zone": "transactions_preprocessing",
        "params":{
            "steps_indexes":{
                "date_column_copy": 0,
                "date_column_renaming": 1,
                "date_parsing": 2, 
                "transactions_identifier_renaming": 3,
                "items_identifier_renaming": 4,
                "items_cleaning": 5,
                "customers_identifier_renaming": 7,
                "row_scope_creation": 10
            }
        } 
    },
    "compute_transactions_rules_filtered_dates":{
        "name":"compute_transactions_rules_filtered_dates",
        "flow_zone": "transactions_preprocessing",
        "params":{}
    },
    "compute_transactions_unique_items":{
        "name":"compute_transactions_unique_items",
        "flow_zone": "transactions_preprocessing",
        "params":{
            "default_group_key": ["transaction_id", "item"],
            "replace_existing_key":True
        }
    },
    "compute_transactions_unique_items_count":{
        "name":"compute_transactions_unique_items_count",
        "flow_zone": "transactions_preprocessing",
        "params":{
            "default_group_key": ["transaction_id"],
            "replace_existing_key":True
        }
    },
    "compute_transaction_distinct_items":{
        "name":"compute_transaction_distinct_items",
        "flow_zone": "transactions_preprocessing",
        "params":{
            "default_group_key": ["transaction_id", "item", "row_scope"],
            "replace_existing_key":True
        }
    },
    "compute_items_count":{
        "name":"compute_items_count",
        "flow_zone": "transactions_preprocessing",
        "params":{
            "default_group_key": ["item", "row_scope"],
            "replace_existing_key":True
        }
    },
    "compute_multiple_items_transactions":{
        "name":"compute_multiple_items_transactions",
        "flow_zone": "transactions_preprocessing",
        "params":{
            "reference_dataset_for_schema":"transactions_rules_filtered_dates",
            "default_join_key": [{'column1': {'name': 'transaction_id', 'table': 0},
                                  'column2': {'name': 'transaction_id', 'table': 1},
                                  'type': 'EQ'}],
            "default_selected_columns": [
                {'name': 'unique_items_count', 'table':1, 'type': 'bigint'}
                                        ]
        }
    },
    "compute_transactions_count":{
        "name":"compute_transactions_count",
        "flow_zone": "transactions_preprocessing",
        "params":{
            "default_group_key": ["row_scope"],
            "replace_existing_key":True
        }
    },
    "compute_items_transactions_count":{
        "name":"compute_items_transactions_count",
        "flow_zone": "transactions_preprocessing",
        "params":{
            "reference_dataset_for_schema":"items_count",
            "default_selected_columns": [{'name': 'item', 'table': 0, 'type': 'string'},
                                         {'name': 'row_scope', 'table': 0, 'type': 'string'},
                                          {'name': 'n_item_purchases', 'table': 0, 'type': 'bigint'},
                                          {'name': 'n_transactions', 'table': 1, 'type': 'bigint'}
                                         ]
        }
    },
    "compute_items_support":{
        "name":"compute_items_support",
        "flow_zone": "transactions_preprocessing",
        "params":{}
    },
    "compute_transactions_count_prepared":{
        "name":"compute_transactions_count_prepared",
        "flow_zone": "transactions_preprocessing",
        "params":{}
    },
    "split_items_support":{
        "name":"split_items_support",
        "flow_zone": "transactions_preprocessing",
        "params":{}
    },
    "split_transactions_count_prepared":{
        "name":"split_transactions_count_prepared",
        "flow_zone": "transactions_preprocessing",
        "params":{}
    },
    "compute_valid_transactions_and_items":{
        "name":"compute_valid_transactions_and_items",
        "flow_zone": "transactions_preprocessing",
        "params":{
            "reference_dataset_for_schema":"transactions_rules_filtered_dates",
            "default_join_keys":{
                0:[{'column1': {'name': 'default_join_key', 'table': 0},
                    'column2': {'name': 'default_join_key', 'table': 1},
                    'type': 'EQ'}],
                1:[{'column1': {'name': 'item', 'table': 0},
                    'column2': {'name': 'item', 'table': 2},
                    'type': 'EQ'}]
            },
            "default_selected_columns": [{'name': 'n_transactions', 'table':1, 'type': 'bigint'},
                                         {'name': 'transaction_to_keep', 'table':1, 'type': 'string'},
                                         {'name': 'n_item_purchases', 'table':2, 'type':'bigint'},
                                         {'name': 'item_support', 'table':2, 'type':'double'},
                                         {'name': 'item_to_keep', 'table':2, 'type':'string'}
                                        ]
        }
    },
    "compute_transactions_aggregated":{
        "name":"compute_transactions_aggregated",
        "flow_zone": "transactions_preprocessing",
        "params":{
            "default_group_key": ["transaction_id", "transaction_date", "row_scope"],
            "replace_existing_key": True,
            "input_dataset_name": "valid_transactions_and_items",
            "items_concatenation_column_name": "transaction_items",
            "custom_aggregation_parameters": {
                "concatDistinct": False,
                "customExpr": "",
                "firstLastNotNull": False,
                "customName": "",
                "type": "STRING"
            }
        }
    },
    "compute_transactions_preprocessed":{
        "name":"compute_transactions_preprocessed",
        "flow_zone": "transactions_preprocessing",
        "params":{}
    },    
    # recommendation_preprocessing :
    "compute_valid_association_rules":{
        "name":"compute_valid_association_rules",
        "flow_zone": "recommendation_preprocessing",
        "params":{}
    },
    "compute_valid_rules_denormalized_antecedents":{
        "name":"compute_valid_rules_denormalized_antecedents",
        "flow_zone": "recommendation_preprocessing",
        "params":{}
    },
    "compute_valid_rules_denormalized_consequents":{
        "name":"compute_valid_rules_denormalized_consequents",
        "flow_zone": "recommendation_preprocessing",
        "params":{}
    },
    "compute_unique_consequent_items":{
        "name":"compute_unique_consequent_items",
        "flow_zone": "recommendation_preprocessing",
        "params":{
            "default_selected_columns":[{'column': 'consequent_item'}]
        }
    },
    "compute_transactions_customers_filtered_dates":{
        "name":"compute_transactions_customers_filtered_dates",
        "flow_zone": "recommendation_preprocessing",
        "params":{}
    },
    "compute_customers_last_transactions":{
        "name":"compute_customers_last_transactions",
        "flow_zone": "recommendation_preprocessing",
        "params":{
            "default_columns_to_retrieve": ["transaction_id", "item", "transaction_date", "customer_id"],
            "default_values":["value"]
        }
    },
    "compute_customers_last_transactions_unique_items":{
        "name":"compute_customers_last_transactions_unique_items",
        "flow_zone": "recommendation_preprocessing",
        "params":{
            "default_group_key": ["customer_id", "item"],
            "replace_existing_key":True
        }
    },
    "compute_unique_customers":{
        "name":"compute_unique_customers",
        "flow_zone": "recommendation_preprocessing",
        "params":{
            "default_group_key": ["customer_id"],
            "replace_existing_key":True
        }
    },
    "compute_customers_last_transactions_unique_items_prepared":{
        "name":"compute_customers_last_transactions_unique_items_prepared",
        "flow_zone": "recommendation_preprocessing",
        "params":{
            "output_dataset":"customers_last_transactions_unique_items_prepared"
        }
    },
    "compute_consequents_potential_customers":{
        "name":"compute_consequents_potential_customers",
        "flow_zone": "recommendation_preprocessing",
        "params":{
            "reference_dataset_for_schema":"unique_consequent_items",
            "default_join_key": [{'column1': {'name': 'cross_join_key', 'table': 0},
                                  'column2': {'name': 'cross_join_key', 'table': 1},
                                  'type': 'EQ'}],
            "default_selected_columns": [{'name': 'consequent_item', 'table': 0, 'type': 'string'},
                                         {'name': 'customer_id', 'table': 1, 'type': 'string'}]
        }
    },
    "compute_cross_sales_candidate_consequents":{
        "name":"compute_cross_sales_candidate_consequents",
        "flow_zone": "recommendation_preprocessing",
        "params":{
            "reference_dataset_for_schema": CANDIDATE_CONSEQUENTS_REFERENCE_DATASET_FOR_SCHEMA,
            "default_join_key": CANDIDATE_CONSEQUENTS_DEFAULT_JOIN_KEYS,
            "default_selected_columns": CANDIDATE_CONSEQUENTS_DEFAULT_JOIN_SELECTED_COLUMNS
        }
    },
    "compute_up_sales_candidate_consequents":{
        "name":"compute_up_sales_candidate_consequents",
        "flow_zone": "recommendation_preprocessing",
        "params":{
            "reference_dataset_for_schema": CANDIDATE_CONSEQUENTS_REFERENCE_DATASET_FOR_SCHEMA,
            "default_join_key": CANDIDATE_CONSEQUENTS_DEFAULT_JOIN_KEYS,
            "default_selected_columns": CANDIDATE_CONSEQUENTS_DEFAULT_JOIN_SELECTED_COLUMNS
        }
    },
    "compute_cross_sales_candidate_consequents_prepared":{
        "name":"compute_cross_sales_candidate_consequents_prepared",
        "flow_zone": "recommendation_preprocessing",
        "params":{
            "steps_indexes":{
                "consequent_renaming": 2
            }
        } 
    },
    "compute_up_sales_candidate_consequents_prepared":{
        "name":"compute_up_sales_candidate_consequents_prepared",
        "flow_zone": "recommendation_preprocessing",
        "params":{} 
    },
    # cross_sales_recommendations &  up_sales_recommendations:
    "compute_cross_sales_candidate_rules":{
        "name":"compute_cross_sales_candidate_rules",
        "flow_zone": "cross_sales_recommendations",
        "params":{
            "reference_dataset_for_schema":"cross_sales_candidate_consequents_prepared",
            "default_join_key": CANDIDATE_RULES_DEFAULT_JOIN_KEYS,
            "default_selected_columns": CANDIDATE_RULES_DEFAULT_JOIN_SELECTED_COLUMNS
        }
    },
    "compute_up_sales_candidate_rules":{
        "name":"compute_up_sales_candidate_rules",
        "flow_zone": "up_sales_recommendations",
        "params":{
            "reference_dataset_for_schema":"up_sales_candidate_consequents_prepared",
            "default_join_key": CANDIDATE_RULES_DEFAULT_JOIN_KEYS,
            "default_selected_columns": CANDIDATE_RULES_DEFAULT_JOIN_SELECTED_COLUMNS
        }
    },
    "compute_cross_sales_required_antecedents":{
        "name":"compute_cross_sales_required_antecedents",
        "flow_zone": "cross_sales_recommendations",
        "params":{
            "reference_dataset_for_schema":"cross_sales_candidate_rules",
            "default_join_key": REQUIRED_ANTECEDENTS_DEFAULT_JOIN_KEYS,
            "default_selected_columns": REQUIRED_ANTECEDENTS_DEFAULT_JOIN_SELECTED_COLUMNS
        }
    },
    "compute_up_sales_required_antecedents":{
        "name":"compute_up_sales_required_antecedents",
        "flow_zone": "up_sales_recommendations",
        "params":{
            "reference_dataset_for_schema":"up_sales_candidate_rules",
            "default_join_key": REQUIRED_ANTECEDENTS_DEFAULT_JOIN_KEYS,
            "default_selected_columns": REQUIRED_ANTECEDENTS_DEFAULT_JOIN_SELECTED_COLUMNS
        }
    },
    "compute_cross_sales_purchased_antecedents":{
        "name":"compute_cross_sales_purchased_antecedents",
        "flow_zone": "cross_sales_recommendations",
        "params":{
            "reference_dataset_for_schema":"cross_sales_required_antecedents",
            "default_join_key": PURCHASED_ANTECEDENTS_DEFAULT_JOIN_KEYS,
            "default_selected_columns": PURCHASED_ANTECEDENTS_DEFAULT_JOIN_SELECTED_COLUMNS
        }
    },
    "compute_up_sales_purchased_antecedents":{
        "name":"compute_up_sales_purchased_antecedents",
        "flow_zone": "up_sales_recommendations",
        "params":{
            "reference_dataset_for_schema":"up_sales_required_antecedents",
            "default_join_key": PURCHASED_ANTECEDENTS_DEFAULT_JOIN_KEYS,
            "default_selected_columns": PURCHASED_ANTECEDENTS_DEFAULT_JOIN_SELECTED_COLUMNS
        }
    },
    "compute_cross_sales_rules_summary":{
        "name":"compute_cross_sales_rules_summary",
        "flow_zone": "cross_sales_recommendations",
        "params":{
            "default_row_identifiers":RULES_SUMMARY_DEFAULT_IDENTIFIERS
        }
    },
    "compute_up_sales_rules_summary":{
        "name":"compute_up_sales_rules_summary",
        "flow_zone": "up_sales_recommendations",
        "params":{
            "default_row_identifiers":RULES_SUMMARY_DEFAULT_IDENTIFIERS
        }
    },
    "compute_cross_sales_actionable_rules":{
        "name":"compute_cross_sales_actionable_rules",
        "flow_zone": "cross_sales_recommendations",
        "params":{}
    },
    "compute_up_sales_actionable_rules":{
        "name":"compute_up_sales_actionable_rules",
        "flow_zone": "up_sales_recommendations",
        "params":{}
    },
    "compute_cross_sales_best_actionable_rules":{
        "name":"compute_cross_sales_best_actionable_rules",
        "flow_zone": "cross_sales_recommendations",
        "params":{
            "default_columns_to_retrieve": BEST_ACTIONABLE_RULES_DEFAULT_COLUMNS_TO_RETRIEVE,
            "default_values":["value"],
            "default_partitioning_columns": BEST_ACTIONABLE_RULES_DEFAULT_PARTITIONING_COLUMNS
        }
    },
    "compute_up_sales_best_actionable_rules":{
        "name":"compute_up_sales_best_actionable_rules",
        "flow_zone": "up_sales_recommendations",
        "params":{
            "default_columns_to_retrieve": BEST_ACTIONABLE_RULES_DEFAULT_COLUMNS_TO_RETRIEVE,
            "default_values":["value"],
            "default_partitioning_columns": BEST_ACTIONABLE_RULES_DEFAULT_PARTITIONING_COLUMNS
        }
    },
    "compute_cross_sales_best_recommendations":{
        "name":"compute_cross_sales_best_recommendations",
        "flow_zone": "cross_sales_recommendations",
        "params":{
            "default_columns_to_retrieve": BEST_RECOMMENDATIONS_DEFAULT_COLUMNS_TO_RETRIEVE,
            "default_values":["value"],
            "default_partitioning_columns": BEST_RECOMMENDATIONS_DEFAULT_PARTITIONING_COLUMNS
        }
    },
    "compute_up_sales_best_recommendations":{
        "name":"compute_up_sales_best_recommendations",
        "flow_zone": "up_sales_recommendations",
        "params":{
            "default_columns_to_retrieve": BEST_RECOMMENDATIONS_DEFAULT_COLUMNS_TO_RETRIEVE,
            "default_values":["value"],
            "default_partitioning_columns": BEST_RECOMMENDATIONS_DEFAULT_PARTITIONING_COLUMNS
        }
    }
}