# Definition

Encoded transactions are transactions having a format required for the association rules search. 
Encoding the transactions is the process of transforming the raw transactions ([Go back to Transactions](article:22)) into that particular format.

# In practice

Two steps will be needed to encode the transactions: 
- Aggregating purchased items at the transaction level.
- Apply [one-hot encoding](https://en.wikipedia.org/wiki/One-hot) on that aggregated items.

# Regarding our case study

## First we start with the raw transactions history

Below, we have one row per product purchased in a transaction :arrow_down::
![transactions_history.png](h3z9j7Kdg9jT)

## Then all items are aggregated at the transactions level

We now have one row per transaction, with the list of the items purchased in that transaction. Having originally 5 transactions, we get 5 rows after the aggregation :arrow_down::
![transactions_aggregated.png](AtBeDATBPeQ0)

## Finally we apply one-hot encoding to the "items" column
We finally still have one row per transaction, but now with boolean columns indicating if a given item was purchased in a transaction or not. They have the value "1" if the product was purchased in a transaction and "0" else. Having initially 11 products sold by the retailer, we get here 11 of these columns. :arrow_down::

![transactions_encoded.png](cHAbjptPRcCU)