# Definition

In association rule learning, an item ***i***  identifies a single entity that can occur with others.

It belongs to the collection of all the items ***I***  = { ***i<sub>1</sub>*** , ***i<sub>2</sub>*** , … , ***i<sub>n</sub>***  }.


# In practice

In Market Basket Analysis, we generally tend to consider products as individual items. With that choice, our objective is to use association rule learning to discover relationships (or "rules") between the products they sell.  But other product information like their category or their brand could be considered as items to respectively discover relationships between the retailer brand or product categories.
Thus you can see that an "item" is more a general concept allowing to designate what will be at the core of the association rules process.


# Regarding our case study

As described in the [association rule learning section](article:8), our goal will be to analyze the 11 products sold by our retailer:
- Bacon.
- Cabbage.
- Chicken.
- Corn.
- Garlic.
- Tomato.
- Salad.
- Pepper.
- Onion.
- Tortilla.
- Mushroom.

![items.png](ICevR7uslMTm)
> All emojis designed by [OpenMoji](https://openmoji.org/) – the open-source emoji and icon project. License: [CC BY-SA 4.0](https://creativecommons.org/licenses/by-sa/4.0/#).

Thus, the collection of all the items in our study is  ***I***  = { ***bacon*** , ***cabbage***, ***chicken***, ***corn***, ***garlic***, ***tomato***, ***salad***, ***pepper***, ***onion***, ***tortilla***, ***mushroom*** }.