# Definition
An itemset  ***X*** can be a single item or a list of items ***i***.

## Examples :

***X*** = {***i<sub>1</sub>*** , ***i<sub>4</sub>***  }
***X*** = { ***i<sub>5</sub>*** }

## Recall about items : 
>  ***Definition***
In association rule learning, an item ***i***  identifies a single entity that can occur with others.
It belongs to the list of all the items ***I***  = { ***i<sub>1</sub>*** , ***i<sub>2</sub>*** , … , ***i<sub>n</sub>***  }.

> ***In practice***
In Market Basket Analysis, we generally tend to consider products as individual items. By doing this, our objective is to use association rule learning to discover relationships (or "rules") between the product they sell.  But other product information like their category or their brand could be considered as items to respectively discover relationships between the retailer brand or product categories.
Thus you can see that an "item" is more a general concept allowing to designate what will be at the core of the association rules process.

# In practice

If we consider products as items, any combination of products purchased together can be considered as an itemset. 
Remember our 11 products were *Bacon, Cabbage, Chicken, Corn, Garlic, Tomato, Salad, Pepper, Onion, Tortilla and Mushroom* :
- {Tomato, Tortilla} is an itemset.
- {Salad, Tomato, Onion} is another one.
- {Cabbage} is another one: Here note that even if it is composed of only 1 product, it remains an "itemset".


# Regarding our case study

Now transactions are encoded, identifying itemsets becomes easier.
For example, we can see below :arrow_down: that: 
- The itemset **{<span style="color:#294E14">*bacon*</span>}** is only recorded in the first transaction "t_1".
- The itemset **{<span style="color:#1D4586">*onion, pepper*</span>}** is recorded in the two first transactions "t_1" and "t_2".

![itemsets.png](JG73mTs6E2pL).

Itemsets are at the core of association rule learning since they compose both their antecedents and consequents ARE itemsets ([recall about association rules](article:23)).