# Definition

In Market Basket Analysis, a transaction ***t*** is a <u>** single record**</u> containing a list of items being purchased together.


# In practice

In practice, retailer transactions tend to not be in a single record format. Instead, they used to have row by row:
- Mandatory: information about the items purchased, the transaction identifier they belong to and the transaction date.
- Sometimes: 
  - Some information about the transactions context, " ([learn more about the transactions context](article:30)) .
  - Some information about the items themselves ([learn more about the items characteristics](article:29)).


# Regarding our case study

Our Market Basket Analysis starts with the simple transactions dataset below :arrow_down:  .

It is composed of: 
- The transactions mandatory columns: 
  - A transaction date (column 1).
  - A transaction identifier (column 2) => we have a **total of 5 transactions** here: t_1, t_2, t_3, t_4, t_5.
  - The "item" column describes which of the **11 marketplace products** were part of a given transaction (column 3).
- Some transactions context columns: 
  - The customer identifier (column 4).
  - The customers living country (column 5): some customers live in the United States while others live in Canada.


![transactions_history.png](h3z9j7Kdg9jT)


That transactions are not ready to be processes as is, and will need to be aggregated, then encoded ([See more about transactions encoding](article:19)) in order to start the association rules search.
