# Definition

The **confidence** of a rule is the **conditional probability** of getting the itemset ***Y*** knowing the itemset ***X ***.
It is noted <span style="color:#9900FE">**conf(**</span>***X => Y *** <span style="color:#9900FE">**)**.

# Formula
 
![rule_confidence_formula.png](6wMFmI6CmggP)

[I don't remember what is the rule support](article:25)

# Concept diving

- It is a measure of the **association rule's likelihood knowing its antecedent**: The higher the confidence of a rule is, the more likely the consequent can be met ONCE the antecedent is met.

- <span style="color:#9900FE">**conf(**</span>***X => Y*** <span style="color:#9900FE">**)**</span> **is in [0, 1]**.
  - <span style="color:#9900FE">**conf(**</span>***X => Y*** <span style="color:#9900FE">**)**</span> is maximum when ***X*** and ***Y*** are always met together.
  - <span style="color:#9900FE">**conf(**</span>***X => Y*** <span style="color:#9900FE">**)**</span>  **!=** <span style="color:#9900FE">**conf(**</span>***Y => X*** <span style="color:#9900FE">**)**</span>.


# Regarding our case study

- We have a total of 5 transactions.
- Rule **{<span style="color:#294E14">bacon => cabbage</span>}**: 
  - **<span style="color:#294E14">bacon</span>** and **<span style="color:#294E14">cabbage</span>** were never purchased together. Thus, <span style="color:#9900FE">**supp(**</span>**{<span style="color:#294E14">bacon => cabbage</span>}**<span style="color:#9900FE">**)**</span> = 0/5 = 0.
  - **<span style="color:#294E14">bacon</span>** was purchased in 1 transaction. Thus <span style="color:#9900FE">**supp(**</span>**{<span style="color:#294E14">bacon</span>}**<span style="color:#9900FE">**)**</span> = 1/5 = 0.2.
  - Finally : <span style="color:#9900FE">**conf(**</span>**{<span style="color:#294E14">bacon => cabbage</span>}**<span style="color:#9900FE">**)**</span> = <span style="color:#9900FE">**supp(**</span>**{<span style="color:#294E14">bacon => cabbage</span>}**<span style="color:#9900FE">**)**</span> / <span style="color:#9900FE">**supp(**</span>**{<span style="color:#294E14">bacon</span>}**<span style="color:#9900FE">**)**</span> = 0 / 0.2 = 0.
  - <span style="color:#294E14">**cabbage**</span> was never purchased in transactions involving <span style="color:#294E14">**bacon**</span>.


![rules_confidence_p1.png](33DfjqyLklg0)


- Rule **{<span style="color:#1D4587">pepper,onion => mushroom</span>}**: 
  - **<span style="color:#1D4587">pepper</span>**, **<span style="color:#1D4587">onion</span>**  and **<span style="color:#1D4587">mushroom</span>** were purchased together in 2 transactions. Thus, <span style="color:#9900FE">**supp(**</span>**{<span style="color:#1D4587">pepper,onion => mushroom</span>}**<span style="color:#9900FE">**)**</span> = 2/5 = 0.4.
  - **<span style="color:#1D4587">pepper</span>** and **<span style="color:#1D4587">onion</span>** were purchased together in 2 transactions. Thus <span style="color:#9900FE">**supp(**</span>**{<span style="color:#1D4587">pepper,onion</span>}**<span style="color:#9900FE">**)**</span> = 2/5 = 0.4.
  - Finally : <span style="color:#9900FE">**conf(**</span>**{<span style="color:#1D4587">pepper,onion => mushroom</span>}**<span style="color:#9900FE">**)**</span> = <span style="color:#9900FE">**supp(**</span>**{<span style="color:#1D4587">pepper,onion => mushroom</span>}**<span style="color:#9900FE">**)**</span> / <span style="color:#9900FE">**supp(**</span>**{<span style="color:#1D4587">pepper,onion</span>}**<span style="color:#9900FE">**)**</span> = 0.4 / 0.4 = 1.
  - 100% of transactions involving <span style="color:#1D4587">**pepper & onion**</span> led to the purchase of <span style="color:#1D4587">**mushroom**</span> . OR the likelihood to purchase <span style="color:#1D4587">**mushroom**</span> knowing that <span style="color:#1D4587">**pepper & onion**</span> were purchased is 1.0.

![rules_confidence_p2.png](oX0v3NiLSde4)


- Rule **{<span style="color:#990002">tomato => salad</span>}**: 
  - **<span style="color:#990002">tomato</span>** and **<span style="color:#990002">salad</span>** were purchased together in 2 transactions. Thus, <span style="color:#9900FE">**supp(**</span>**{<span style="color:#990002">tomato => salad</span>}**<span style="color:#9900FE">**)**</span> = 2/5 = 0.4.
  - **<span style="color:#990002">tomato</span>** was purchased in all transactions. Thus <span style="color:#9900FE">**supp(**</span>**{<span style="color:#990002">tomato</span>}**<span style="color:#9900FE">**)**</span> = 5/5 = 1.
  - Finally : <span style="color:#9900FE">**conf(**</span>**{<span style="color:#990002">tomato => salad</span>}**<span style="color:#9900FE">**)**</span> = <span style="color:#9900FE">**supp(**</span>**{<span style="color:#990002">tomato => salad</span>}**<span style="color:#9900FE">**)**</span> / <span style="color:#9900FE">**supp(**</span>**{<span style="color:#990002">tomato</span>}**<span style="color:#9900FE">**)**</span> = 0.4 / 1 = 0.4. 
  - 40% of transactions involving <span style="color:#990002">**tomato**</span> led to the purchase of <span style="color:#990002">**salad**</span> .
  
  
- Rule **{<span style="color:#990002">salad => tomato</span>}**: 
  - **<span style="color:#990002">salad</span>** and **<span style="color:#990002">tomato</span>** were purchased together in 2 transactions. Thus, <span style="color:#9900FE">**supp(**</span>**{<span style="color:#990002">salad => tomato</span>}**<span style="color:#9900FE">**)**</span> = 2/5 = 0.4.
  - **<span style="color:#990002">salad</span>** was purchased in 2 transactions : "t_3" and "t_5". Thus <span style="color:#9900FE">**supp(**</span>**{<span style="color:#990002">salad</span>}**<span style="color:#9900FE">**)**</span> = 2/5 = 0.4.
  - Finally : <span style="color:#9900FE">**conf(**</span>**{<span style="color:#990002">salad => tomato</span>}**<span style="color:#9900FE">**)**</span> = <span style="color:#9900FE">**supp(**</span>**{<span style="color:#990002">salad => tomato</span>}**<span style="color:#9900FE">**)**</span> / <span style="color:#9900FE">**supp(**</span>**{<span style="color:#990002">salad</span>}**<span style="color:#9900FE">**)**</span> = 0.4 / 0.4 = 1. 
  - 100% of transactions involving <span style="color:#990002">**tomato**</span> led to the purchase of <span style="color:#990002">**salad**</span> .

![rules_confidence_p3.png](tkBkjgpsQm8C)
